/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

public class JdbcData {
    public static final String DEFAULT_SONAR_DS_JNDI_NAME = "java:comp/env/jdbc/sonar";
    public static final String DEFAULT_SONAR_DIALECT = JDBCDialect.DERBY.toString();
    private String url;
    private String driverClassName;
    private String username;
    private String password;
    private String datasource;
    private boolean cacheEnabled;
    private int isolationLevel;
    private JDBCDialect dsDialect;

    public JdbcData(String url, String driverClassName, String username, String password) {
        this.url = url;
        this.driverClassName = driverClassName;
        this.username = username;
        this.password = password;
        this.cacheEnabled = true;
        this.isolationLevel = 1;
    }

    public JdbcData(String datasource, String dsDialect) {
        this.datasource = datasource;
        this.dsDialect = JDBCDialect.fromString(dsDialect);
        this.cacheEnabled = true;
        this.isolationLevel = 1;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void disableCache() {
        this.cacheEnabled = false;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public JDBCDialect getDsDialect() {
        return this.dsDialect;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    public int hashCode() {
        if (this.getDatasource() != null) {
            return ((Object)((Object)this.getDsDialect()) + this.getDatasource() + this.isCacheEnabled() + this.getIsolationLevel()).hashCode();
        }
        return (this.getUsername() + this.getPassword() + this.getUrl() + this.getDriverClassName() + this.isCacheEnabled() + this.getIsolationLevel()).hashCode();
    }

    public final String toString() {
        String separator = " # ";
        if (this.getDatasource() != null) {
            return this.getDatasource() + " # " + (Object)((Object)this.getDsDialect()) + " # " + this.isCacheEnabled() + " # " + this.getIsolationLevel();
        }
        return this.getUrl() + " # " + this.getDriverClassName() + " # " + this.getUsername() + " # " + this.getPassword() + " # " + this.isCacheEnabled() + " # " + this.getIsolationLevel();
    }

    public static class Hsqldb
    extends JdbcData {
        public Hsqldb() {
            super("jdbc:hsqldb:mem:sonar", "org.hsqldb.jdbcDriver", "sa", null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JDBCDialect {
        DB2,
        DERBY,
        HSQLDB,
        MSSQL,
        MYSQL,
        ORACLE,
        POSTGRE;


        private static JDBCDialect fromString(String dialect) throws IllegalArgumentException {
            for (JDBCDialect dialectEnum : JDBCDialect.values()) {
                if (!dialectEnum.toString().equalsIgnoreCase(dialect)) continue;
                return dialectEnum;
            }
            throw new IllegalArgumentException("Unable to map dialect " + dialect + " to one of the JDBCDialect enumeration value");
        }
    }
}

