/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

import ch.hortis.sonar.model.ProjectLink;
import ch.hortis.sonar.model.SnapshotGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Entity
@Table(name="projects")
@NamedQueries(value={@NamedQuery(name="MavenProject.selectByMVNId", query="SELECT p FROM MavenProject p WHERE p.groupId = :groupId AND p.artifactId = :artifactId AND p.branch = :branch AND p.enabled = true"), @NamedQuery(name="MavenProject.selectById", query="SELECT p FROM MavenProject p WHERE p.id = :id"), @NamedQuery(name="MavenProject.selectByParentProjectId", query="SELECT p FROM MavenProject p WHERE p.parent.id = :id"), @NamedQuery(name="MavenProject.selectDisabledProjects", query="SELECT p FROM MavenProject p WHERE p.enabled=false AND p.parent IS NULL")})
public class MavenProject
implements Serializable {
    public static final String SQL_SELECT_BY_MVN_ID = "MavenProject.selectByMVNId";
    public static final String SQL_SELECT_BY_ID = "MavenProject.selectById";
    public static final String SQL_SELECT_BY_PARENT_PROJECT_ID = "MavenProject.selectByParentProjectId";
    public static final String SQL_SELECT_DISABLED_PROJECTS = "MavenProject.selectDisabledProjects";
    public static final String DEFAULT_BRANCH = "HEAD";
    private static final long serialVersionUID = -7747333646654989328L;
    public static final int DESCRIPTION_COLUMN_SIZE = 2000;
    public static final int NAME_COLUMN_SIZE = 256;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="PROJECTS_SEQ", sequenceName="PROJECTS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="PROJECTS_SEQ")
    private Integer id;
    @Column(name="artifact_id", updatable=false, nullable=false, length=256)
    private String artifactId;
    @Column(name="group_id", updatable=false, nullable=false, length=256)
    private String groupId;
    @Column(name="name", updatable=true, nullable=true, length=256)
    private String name;
    @Column(name="description", updatable=true, nullable=true, length=2000)
    private String description;
    @Column(name="branch", updatable=false, nullable=false, length=64)
    private String branch = "HEAD";
    @Column(name="enabled", updatable=true, nullable=false)
    private Boolean enabled = true;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="parent_project_id", updatable=true, nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private MavenProject parent;
    @OneToMany(mappedBy="mavenProject", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @BatchSize(size=8)
    private List<ProjectLink> projectLinks = new ArrayList<ProjectLink>();
    @OneToMany(mappedBy="mavenProject", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @BatchSize(size=32)
    private List<SnapshotGroup> snapshotGroups = new ArrayList<SnapshotGroup>();

    public MavenProject(String groupId, String artifactId, String name) {
        this();
        this.artifactId = artifactId;
        this.groupId = groupId;
        this.name = name;
    }

    public MavenProject(String groupId, String artifactId, String name, MavenProject parent) {
        this(artifactId, groupId, name);
        this.parent = parent;
    }

    public MavenProject() {
    }

    public List<ProjectLink> getProjectLinks() {
        return this.projectLinks;
    }

    public void setProjectLinks(List<ProjectLink> projectLinks) {
        this.projectLinks = projectLinks;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtils.abbreviate((String)description, (int)2000);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.abbreviate((String)name, (int)256);
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) throws IllegalArgumentException {
        this.checkNotNull(branch);
        this.branch = branch;
    }

    public MavenProject getParent() {
        return this.parent;
    }

    public void setParent(MavenProject parent) {
        this.parent = parent;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) throws IllegalArgumentException {
        this.checkNotNull(artifactId);
        this.artifactId = artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) throws IllegalArgumentException {
        this.checkNotNull(groupId);
        this.groupId = groupId;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<SnapshotGroup> getSnapshotGroups() {
        return this.snapshotGroups;
    }

    public void setSnapshotGroups(List<SnapshotGroup> snapshotGroups) {
        this.snapshotGroups = snapshotGroups;
    }

    private void checkNotNull(String attribute) {
        if (attribute == null || attribute.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
    }

    public ProjectLink getProjectLinkByType(String type) {
        if (type == null) {
            return null;
        }
        for (ProjectLink projectLink : this.projectLinks) {
            if (!type.equals(projectLink.getType())) continue;
            return projectLink;
        }
        return null;
    }
}

