/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

import ch.hortis.sonar.model.MetricType;
import ch.hortis.sonar.model.Metrics;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;

@Immutable
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
@Entity(name="Metric")
@Table(name="metrics")
@NamedQueries(value={@NamedQuery(name="Metrics.selectByName", query="SELECT m FROM Metric m WHERE  m.name = :name"), @NamedQuery(name="Metrics.selectAll", query="SELECT m FROM Metric m")})
public class Metric {
    public static final String SQL_SELECT_BY_NAME = "Metrics.selectByName";
    public static final String SQL_SELECT_ALL = "Metrics.selectAll";
    @Id
    @Column(name="id")
    @SequenceGenerator(name="METRICS_SEQ", sequenceName="METRICS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="METRICS_SEQ")
    private Integer id;
    @Column(name="name", updatable=false, nullable=false, length=64)
    private String name;
    @Column(name="description", updatable=false, nullable=true, length=128)
    private String description;
    @Column(name="value_type", updatable=false, nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private MetricType type;
    @Column(name="direction", updatable=false, nullable=true)
    private Integer direction;

    public Metric() {
    }

    public Metric(String name, MetricType type) {
        this.name = name;
        this.type = type;
    }

    public Metric(Metrics metric, MetricType type) {
        this(metric.getName(), type);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetricType getType() {
        return this.type;
    }

    public void setType(MetricType type) {
        this.type = type;
    }

    public static Number getParsedValue(MetricType type, Double value) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case DOUBLE: {
                return value;
            }
            case FLOAT: 
            case PERCENTAGE: {
                return Float.valueOf(value.floatValue());
            }
            case INT: {
                return value.intValue();
            }
            case LONG: {
                return value.longValue();
            }
            case SHORT: {
                return value.shortValue();
            }
            case BYTE: {
                return value.byteValue();
            }
            case DURATION_MS: {
                return value.longValue();
            }
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMetric(Metrics metric) {
        if (this.name == null && metric.getName() != null) {
            return false;
        }
        return this.name.equals(metric.getName());
    }

    public Integer getDirection() {
        return this.direction;
    }

    public void setDirection(Integer direction) {
        this.direction = direction;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Metric)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Metric other = (Metric)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.id).isEquals();
    }

    public String toString() {
        return this.name;
    }
}

