/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Metrics {
    COBERTURA_LINE_COVERAGE("cobertura_line_rate", false),
    COBERTURA_BRANCH_COVERAGE("cobertura_branch_rate", false),
    CLOVER_COVERAGE("clover_code_coverage", false),
    NCSS_PACKAGES("packages", false),
    NCSS_CLASSES("classes", false),
    NCSS_NCSS("ncss", true),
    NCSS_FUNCTIONS("functions", false),
    JDEPEND_TOTAL_CLASSES("totalClasses", false),
    JDEPEND_CONCRETE_CLASSES("concreteClasses", false),
    JDEPEND_ABSTRACT_CLASSES("abstractClasses", false),
    JDEPEND_AFFERENT_COUPLINGS("ca", false),
    JDEPEND_EFFERENT_COUPLINGS("ce", false),
    JDEPEND_ABSTRACTNESS("a", false),
    JDEPEND_INSTABILITY("i", false),
    JDEPEND_DISTANCE("d", false),
    JDEPEND_VOLATILITY("v", false),
    JDEPEND_PACKAGE_DEPENDENCY_CYCLES("packageCycle", false),
    PMD_DUPLICATION("duplication", false),
    PMD_DUPLICATED_LINES("duplicatedLines", true),
    PMD_DUPLICATED_TOKENS("duplicatedTokens", false),
    SUREFIRE_ERRORS("errors", false),
    SUREFIRE_SKIPPED("skipped", false),
    SUREFIRE_FAILURES("failures", false),
    SUREFIRE_TESTS("tests", true),
    SUREFIRE_TIME("time", true),
    SUREFIRE_SUCCESS_PERCENTAGE("successPercentage", false),
    SUREFIRE_ERRORS_PERCENTAGE("errorsPercentage", false),
    SUREFIRE_FAILURE_PERCENTAGE("failurePercentage", false),
    CHANGELOG_COMMITS("commits", true),
    CHANGELOG_FILE_COMMITS("fileCommits", true),
    CK_WMC("wmc", false),
    CK_DIT("dit", false),
    CK_NOC("noc", false),
    CK_CBO("cbo", false),
    CK_RFC("rfc", false),
    CK_LCOM("lcom", false),
    CK_CA("ca", false),
    CK_NPM("npm", false),
    CYCLOMATIC_COMPLEXITY("ccn", true),
    CYCLOMATIC_COMPLEXITY_AVG_CLASS("ccn_class", true),
    CYCLOMATIC_COMPLEXITY_AVG_FUNCTION("ccn_function", true),
    CODE_COVERAGE("code_coverage", true),
    ERROR_RULES_INDEX("error_rules_index", true),
    ERROR_RULES_COUNT("error_rules_count", true),
    WARNING_RULES_INDEX("warning_rules_index", true),
    WARNING_RULES_COUNT("warning_rules_count", true);

    private String name;
    private boolean tendencyAble;

    private Metrics(String name, boolean tendencyAble) {
        this.name = name;
        this.tendencyAble = tendencyAble;
    }

    public String getName() {
        return this.name;
    }

    public static Metrics[] tendencyableMetrics() {
        ArrayList<Metrics> tendencyable = new ArrayList<Metrics>();
        for (Metrics metric : Metrics.values()) {
            if (!metric.tendencyAble) continue;
            tendencyable.add(metric);
        }
        Metrics[] metrics = new Metrics[tendencyable.size()];
        return tendencyable.toArray(metrics);
    }
}

