/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.MetricMeasure;
import ch.hortis.sonar.model.Rule;
import ch.hortis.sonar.model.RulesCategory;
import ch.hortis.sonar.model.Snapshot;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.ToStringBuilder;

@Entity(name="ProjectMeasure")
@Table(name="project_measures")
@NamedQueries(value={@NamedQuery(name="ProjectMeasure.selectHistory", query="SELECT m FROM ProjectMeasure m, Snapshot s, MavenProject pr WHERE s.mavenProject = pr AND m.snapshot = s AND pr = :project AND m.metric IN (:metrics) AND m.rule IS NULL ORDER BY s.createdAt, m.rulesCategory, m.rule"), @NamedQuery(name="ProjectMeasure.selectMeasuresWithRules", query="SELECT m FROM ProjectMeasure m, Snapshot s WHERE m.snapshot = s AND s.createdAt <= :date AND ( m.rule IS NOT NULL OR m.rulesCategory IS NOT NULL )")})
public class ProjectMeasure
extends MetricMeasure
implements Serializable,
Collectable {
    public static final String SQL_SELECT_HISTORY = "ProjectMeasure.selectHistory";
    public static final String SQL_SELECT_MEASURE_WITH_RULES = "ProjectMeasure.selectMeasuresWithRules";
    private static final long serialVersionUID = 1254625932181589812L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="PROJECT_MEASURES_SEQ", sequenceName="PROJECT_MEASURES_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="PROJECT_MEASURES_SEQ")
    private Integer id;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setFloatValue(Float value) {
        this.value = value.doubleValue();
    }

    public void setIntValue(Integer value) {
        this.value = value.doubleValue();
    }

    public void setLongValue(Long value) {
        this.value = value.doubleValue();
    }

    public void setShortValue(Short value) {
        this.value = value.doubleValue();
    }

    public void setByteValue(Byte value) {
        this.value = value.doubleValue();
    }

    public void setPercentageValue(Float value) {
        this.value = value.doubleValue();
    }

    public ProjectMeasure() {
    }

    public ProjectMeasure(Snapshot snapshot, Metric metric, Double value) {
        this.setSnapshot(snapshot);
        this.metric = metric;
        this.value = value;
    }

    public ProjectMeasure(Snapshot snapshot, Metric metric, Double value, RulesCategory categ) {
        this.setSnapshot(snapshot);
        this.setRulesCategory(categ);
        this.metric = metric;
        this.value = value;
    }

    public ProjectMeasure(Snapshot snapshot, Metric metric, Double value, RulesCategory categ, Rule rule) {
        this.setSnapshot(snapshot);
        this.setRulesCategory(categ);
        this.setRule(rule);
        this.metric = metric;
        this.value = value;
    }

    public ProjectMeasure(Metric metric, Double value) {
        this(null, metric, value);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("value", (Object)this.value).append("metric", (Object)this.metric).toString();
    }
}

