/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

import ch.hortis.sonar.model.RulesCategory;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;

@Immutable
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
@Entity
@Table(name="rules")
@NamedQueries(value={@NamedQuery(name="Rule.selectAll", query="SELECT r FROM Rule r")})
public class Rule {
    public static final String SQL_SELECT_ALL = "Rule.selectAll";
    @Id
    @Column(name="id")
    @SequenceGenerator(name="RULES_SEQ", sequenceName="RULES_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RULES_SEQ")
    private Integer id;
    @Column(name="name", updatable=false, nullable=false)
    private String name;
    @Column(name="plugin_rule_key", updatable=false, nullable=true)
    private String pluginRuleKey;
    @Column(name="plugin_config_key", updatable=false, nullable=true)
    private String pluginConfigKey;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rules_category_id", updatable=false, nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
    private RulesCategory rulesCategory;
    @Column(name="plugin_name", updatable=false, nullable=true)
    private String pluginName;

    public Rule() {
    }

    public Rule(String name, String pluginRuleKey, RulesCategory rulesCategory, String pluginName) {
        this.name = name;
        this.pluginRuleKey = pluginRuleKey;
        this.rulesCategory = rulesCategory;
        this.pluginName = pluginName;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPluginRuleKey() {
        return this.pluginRuleKey;
    }

    public void setPluginRuleKey(String pluginRuleKey) {
        this.pluginRuleKey = pluginRuleKey;
    }

    public RulesCategory getRulesCategory() {
        return this.rulesCategory;
    }

    public void setRulesCategory(RulesCategory rulesCategory) {
        this.rulesCategory = rulesCategory;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getPluginConfigKey() {
        return this.pluginConfigKey;
    }

    public void setPluginConfigKey(String pluginConfigKey) {
        this.pluginConfigKey = pluginConfigKey;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rule)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Rule other = (Rule)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
    }

    public String toString() {
        return this.id.toString().concat(":").concat(this.name);
    }
}

