/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

import ch.hortis.sonar.model.Rule;
import ch.hortis.sonar.model.RuleFailureLevel;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="rules_configs")
@NamedQueries(value={@NamedQuery(name="RuleConfig.selectAllForLevel", query="SELECT rc FROM RuleConfig rc WHERE rc.level = :level")})
public class RuleConfig
implements Serializable {
    private static final long serialVersionUID = -6161808961786732538L;
    public static final String SQL_SELECT_ALL_FOR_LEVEL = "RuleConfig.selectAllForLevel";
    @Id
    @Column(name="id")
    @SequenceGenerator(name="RULES_CONFIGS_SEQ", sequenceName="RULES_CONFIGS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RULES_CONFIGS_SEQ")
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rule_id", updatable=false, nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private Rule rule;
    @Column(name="failure_level", updatable=true, nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private RuleFailureLevel level;

    public RuleConfig() {
    }

    public RuleConfig(Rule rule, RuleFailureLevel level) {
        this.rule = rule;
        this.level = level;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public RuleFailureLevel getLevel() {
        return this.level;
    }

    public void setLevel(RuleFailureLevel level) {
        this.level = level;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuleConfig)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RuleConfig other = (RuleConfig)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
    }
}

