/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.File;
import ch.hortis.sonar.model.Parameter;
import ch.hortis.sonar.model.Rule;
import ch.hortis.sonar.model.RuleFailureLevel;
import ch.hortis.sonar.model.Snapshot;
import ch.hortis.sonar.model.WithFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="rule_failures")
public class RuleFailure
implements Serializable,
WithFile,
Collectable {
    private static final long serialVersionUID = 6573631005994829171L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="RULE_FAILURES_SEQ", sequenceName="RULE_FAILURES_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RULE_FAILURES_SEQ")
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="snapshot_id")
    private Snapshot snapshot;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="file_id", updatable=true, nullable=true)
    private File file;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rule_id")
    private Rule rule;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE})
    @JoinTable(name="rule_failures_parameters", joinColumns={@JoinColumn(name="rule_failure_id")}, inverseJoinColumns={@JoinColumn(name="parameter_id")})
    private List<Parameter> parameters;
    @Column(name="failure_level", updatable=false, nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private RuleFailureLevel failureLevel;
    @Column(name="message", updatable=false, nullable=true)
    private String message;

    public RuleFailure() {
    }

    public RuleFailure(File file, Rule rule, RuleFailureLevel level) {
        this.file = file;
        this.rule = rule;
        this.failureLevel = level;
        this.parameters = new ArrayList<Parameter>();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public RuleFailureLevel getLevel() {
        return this.failureLevel;
    }

    public void setLevel(RuleFailureLevel level) {
        this.failureLevel = level;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String key, Double value) {
        this.addParameter(key, value, null);
    }

    public void addParameter(String key, Double value, Double value2) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(new Parameter(key, value, value2));
    }

    public Parameter getParameter(String key) {
        for (Parameter param : this.parameters) {
            if (!param.getKey().equals(key)) continue;
            return param;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuleFailure)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RuleFailure other = (RuleFailure)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
    }
}

