/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

import ch.hortis.sonar.model.File;
import ch.hortis.sonar.model.FileMeasure;
import ch.hortis.sonar.model.MavenProject;
import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.MetricMeasure;
import ch.hortis.sonar.model.ProjectMeasure;
import ch.hortis.sonar.model.ProjectTendency;
import ch.hortis.sonar.model.RuleFailure;
import ch.hortis.sonar.model.RuleFailureLevel;
import ch.hortis.sonar.model.SnapshotGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="snapshots")
@NamedQueries(value={@NamedQuery(name="Snapshot.selectAll", query="SELECT m FROM Snapshot m, MavenProject pr WHERE m.mavenProject = pr.id AND pr.id = :idProject ORDER BY m.createdAt")})
public class Snapshot
implements Serializable {
    public static final String SQL_SELECT_ALL = "Snapshot.selectAll";
    private static final long serialVersionUID = -6637859483638004953L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="SNAPSHOTS_SEQ", sequenceName="SNAPSHOTS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SNAPSHOTS_SEQ")
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="project_id", updatable=false, nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private MavenProject mavenProject;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="snapshot_group_id", updatable=false, nullable=false)
    private SnapshotGroup snapshotGroup;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at", updatable=false, nullable=false)
    private Date createdAt;
    @Column(name="version", updatable=true, nullable=true, length=32)
    private String version;
    @Column(name="processed")
    private Boolean processed = Boolean.FALSE;
    @OneToMany(mappedBy="snapshot", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @BatchSize(size=128)
    private List<File> files = new ArrayList<File>(256);
    @OneToMany(mappedBy="snapshot", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @BatchSize(size=128)
    private List<ProjectMeasure> projectMeasures = new ArrayList<ProjectMeasure>(512);
    @OneToMany(mappedBy="snapshot", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @BatchSize(size=128)
    private List<ProjectTendency> tendencies = new ArrayList<ProjectTendency>(256);
    @OneToMany(mappedBy="snapshot", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @BatchSize(size=128)
    private List<FileMeasure> fileMeasures = new ArrayList<FileMeasure>(512);
    @OneToMany(mappedBy="snapshot", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @BatchSize(size=256)
    private List<RuleFailure> ruleFailures = new ArrayList<RuleFailure>(1024);

    public Snapshot() {
    }

    public Snapshot(MavenProject mavenProject, SnapshotGroup snapshotGroup, Date date) {
        this.mavenProject = mavenProject;
        this.snapshotGroup = snapshotGroup;
        this.createdAt = date;
    }

    public Boolean getProcessed() {
        return this.processed;
    }

    public void setProcessed(Boolean processed) {
        this.processed = processed;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public List<FileMeasure> getFileMeasures() {
        return this.fileMeasures;
    }

    public void setFileMeasures(List<FileMeasure> fileMeasures) {
        this.fileMeasures = fileMeasures;
    }

    public List<ProjectMeasure> getProjectMeasures() {
        return this.projectMeasures;
    }

    public void setProjectMeasures(List<ProjectMeasure> projectMeasures) {
        this.projectMeasures = projectMeasures;
    }

    public List<RuleFailure> getRuleFailures() {
        return this.ruleFailures;
    }

    public List<RuleFailure> getRuleFailures(RuleFailureLevel level) {
        return this.getRuleFailures(level, null, null);
    }

    public void setRuleFailures(List<RuleFailure> ruleFailures) {
        this.ruleFailures = ruleFailures;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public SnapshotGroup getSnapshotGroup() {
        return this.snapshotGroup;
    }

    public void setSnapshotGroup(SnapshotGroup snapshotGroup) {
        this.snapshotGroup = snapshotGroup;
    }

    public List<ProjectTendency> getTendencies() {
        return this.tendencies;
    }

    public void setTendencies(List<ProjectTendency> tendencies) {
        this.tendencies = tendencies;
    }

    public List<RuleFailure> getRuleFailures(RuleFailureLevel level, Integer categId, Integer ruleId) {
        ArrayList<RuleFailure> result = new ArrayList<RuleFailure>();
        for (RuleFailure failure : this.getRuleFailures()) {
            if (!failure.getLevel().equals((Object)level)) continue;
            if (categId != null && failure.getRule().getRulesCategory().getId().equals(categId)) {
                result.add(failure);
                continue;
            }
            if (ruleId != null && failure.getRule().getId().equals(ruleId)) {
                result.add(failure);
                continue;
            }
            if (ruleId != null || categId != null) continue;
            result.add(failure);
        }
        return result;
    }

    public Map<File, Collection<FileMeasure>> getGroupedFileMeasures() {
        HashMap<File, Collection<FileMeasure>> files = new HashMap<File, Collection<FileMeasure>>();
        for (FileMeasure measure : this.getFileMeasures()) {
            File fle = measure.getFile();
            ArrayList<FileMeasure> measures = (ArrayList<FileMeasure>)files.get(fle);
            if (measures == null) {
                measures = new ArrayList<FileMeasure>();
                files.put(fle, measures);
            }
            measures.add(measure);
        }
        return files;
    }

    public ProjectMeasure getProjectMeasure(Metric metric) {
        return (ProjectMeasure)Snapshot.getMetricMeasure(metric, this.getProjectMeasures(), null, null);
    }

    public List<ProjectMeasure> getProjectMeasuresOnCategories(Metric metric) {
        ArrayList<ProjectMeasure> result = new ArrayList<ProjectMeasure>();
        for (ProjectMeasure measure : this.getProjectMeasures()) {
            if (measure.getRuleId() != null || measure.getRulesCategoryId() == null || !measure.getMetric().equals(metric)) continue;
            result.add(measure);
        }
        return result;
    }

    public List<ProjectMeasure> getProjectMeasuresOnRules(Metric metric) {
        ArrayList<ProjectMeasure> result = new ArrayList<ProjectMeasure>();
        for (ProjectMeasure measure : this.getProjectMeasures()) {
            if (measure.getRuleId() == null || !measure.getMetric().equals(metric)) continue;
            result.add(measure);
        }
        return result;
    }

    public ProjectMeasure getProjectMeasure(Metric metric, Integer rulesCategoryId, Integer ruleId) {
        return (ProjectMeasure)Snapshot.getMetricMeasure(metric, this.getProjectMeasures(), rulesCategoryId, ruleId);
    }

    public FileMeasure getFileMeasure(Metric metric) {
        return (FileMeasure)Snapshot.getMetricMeasure(metric, this.getFileMeasures(), null, null);
    }

    public static <T extends MetricMeasure> T getMetricMeasure(Metric metric, Collection<? extends MetricMeasure> measures, Integer rulesCategoryId, Integer ruleId) {
        for (MetricMeasure metricMeasure : measures) {
            if (!metricMeasure.getMetric().equals(metric) || !(ruleId != null && metricMeasure.getRuleId().equals(ruleId) || ruleId == null && rulesCategoryId != null && metricMeasure.getRulesCategoryId().equals(rulesCategoryId) && metricMeasure.getRuleId() == null) && (ruleId != null || rulesCategoryId != null || metricMeasure.getRulesCategoryId() != null || metricMeasure.getRuleId() != null)) continue;
            return (T)metricMeasure;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Snapshot other = (Snapshot)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.getId()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).toHashCode();
    }
}

