/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.model;

import ch.hortis.sonar.model.MavenProject;
import ch.hortis.sonar.model.Snapshot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="snapshot_groups")
@NamedQueries(value={@NamedQuery(name="SnapshotGroup.selectLastProcessed", query="SELECT s FROM SnapshotGroup s, MavenProject pr WHERE s.mavenProject = pr.id AND pr.id = :idProject AND s.last=true and s.processed=true"), @NamedQuery(name="SnapshotGroup.selectLast", query="SELECT s FROM SnapshotGroup s, MavenProject pr WHERE s.mavenProject = pr.id AND pr.id = :idProject AND s.last=false and s.processed=false ORDER BY s.createdAt DESC"), @NamedQuery(name="SnapshotGroup.selectUnprocessed", query="SELECT s FROM SnapshotGroup s WHERE s.processed=false ORDER BY s.createdAt DESC"), @NamedQuery(name="SnapshotGroup.selectGroupsForDate", query="SELECT s FROM SnapshotGroup s WHERE s.createdAt < :createdAt AND s.processed = false"), @NamedQuery(name="SnapshotGroup.selectGroupsToPurge", query="SELECT s FROM SnapshotGroup s WHERE s.purged=false AND s.last=false AND s.processed=true")})
public class SnapshotGroup
implements Serializable {
    private static final long serialVersionUID = 1292401756725899240L;
    public static final String SQL_SELECT_LAST_PROCESSED = "SnapshotGroup.selectLastProcessed";
    public static final String SQL_SELECT_LAST_UNPROCESSED = "SnapshotGroup.selectLast";
    public static final String SQL_SELECT_UNPROCESSED = "SnapshotGroup.selectUnprocessed";
    public static final String SQL_SELECT_GROUPS_FOR_DATE = "SnapshotGroup.selectGroupsForDate";
    public static final String SQL_SELECT_GROUPS_TO_PURGE = "SnapshotGroup.selectGroupsToPurge";
    @Id
    @Column(name="id")
    @SequenceGenerator(name="SNAPSHOT_GROUPS_SEQ", sequenceName="SNAPSHOT_GROUPS_SEQ")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SNAPSHOT_GROUPS_SEQ")
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="project_id", updatable=false, nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
    private MavenProject mavenProject;
    @Column(name="islast")
    private Boolean last = Boolean.FALSE;
    @Column(name="processed")
    private Boolean processed = Boolean.FALSE;
    @Column(name="purged")
    private Boolean purged = Boolean.FALSE;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_at", updatable=false, nullable=false)
    private Date createdAt;
    @OneToMany(mappedBy="snapshotGroup", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Collection<Snapshot> snapshots = new ArrayList<Snapshot>();

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getLast() {
        return this.last;
    }

    public void setLast(Boolean last) {
        this.last = last;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public Boolean getProcessed() {
        return this.processed;
    }

    public void setProcessed(Boolean processed) {
        this.processed = processed;
    }

    public Boolean getPurged() {
        return this.purged;
    }

    public void setPurged(Boolean purged) {
        this.purged = purged;
    }

    public Collection<Snapshot> getSnapshots() {
        return this.snapshots;
    }

    public void setSnapshots(Collection<Snapshot> snapshots) {
        this.snapshots = snapshots;
    }

    public SnapshotGroup() {
    }

    public SnapshotGroup(MavenProject mavenProject, Boolean last, Boolean processed, Date createdAt) {
        this.mavenProject = mavenProject;
        this.last = last;
        this.processed = processed;
        this.createdAt = createdAt;
    }

    public Snapshot getRootSnapshot() {
        Snapshot rootSnapshot = null;
        for (Snapshot snapshot : this.getSnapshots()) {
            if (!snapshot.getMavenProject().getId().equals(this.getMavenProject().getId())) continue;
            rootSnapshot = snapshot;
        }
        return rootSnapshot;
    }

    public List<Snapshot> getDirectChildren(Snapshot father) {
        ArrayList<Snapshot> children = new ArrayList<Snapshot>();
        for (Snapshot snapshot : this.getSnapshots()) {
            if (snapshot.getMavenProject().getParent() == null || !snapshot.getMavenProject().getParent().getId().equals(father.getMavenProject().getId())) continue;
            children.add(snapshot);
        }
        return children;
    }
}

