/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.service;

import ch.hortis.sonar.model.MavenProject;
import ch.hortis.sonar.service.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProjectService
extends Service {
    public MavenProjectService(EntityManager manager) {
        super(manager);
    }

    public MavenProject getMavenProject(String groupId, String artifactId, String branch) throws NoResultException {
        Query query = this.manager.createNamedQuery("MavenProject.selectByMVNId");
        query.setParameter("groupId", (Object)groupId);
        query.setParameter("artifactId", (Object)artifactId);
        query.setParameter("branch", (Object)branch);
        MavenProject mavenProject = (MavenProject)query.getSingleResult();
        this.log.debug("Found maven project db row " + mavenProject.getId() + " " + mavenProject.getArtifactId());
        return mavenProject;
    }

    public Collection<MavenProject> getModules(MavenProject project, boolean includeSubmodules) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        Query query = this.manager.createNamedQuery("MavenProject.selectByParentProjectId");
        query.setParameter("id", (Object)project.getId());
        List modules = query.getResultList();
        result.addAll(modules);
        if (includeSubmodules) {
            for (MavenProject module : modules) {
                Collection<MavenProject> submodules = this.getModules(module, true);
                result.addAll(submodules);
            }
        }
        return result;
    }
}

