/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.service;

import ch.hortis.sonar.model.File;
import ch.hortis.sonar.model.FileMeasure;
import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.ProjectMeasure;
import ch.hortis.sonar.model.Rule;
import ch.hortis.sonar.model.RulesCategory;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class MeasureKey
implements Cloneable {
    protected File file;
    protected Metric metric;
    protected RulesCategory rulesCategory;
    protected Rule rule;

    public MeasureKey(Metric metric, RulesCategory rulesCategory, Rule rule, File file) {
        this.file = file;
        this.metric = metric;
        this.rulesCategory = rulesCategory;
        this.rule = rule;
    }

    public MeasureKey(Metric metric) {
        this(metric, null, null, null);
    }

    public MeasureKey(Metric metric, RulesCategory rulesCategory, Rule rule) {
        this(metric, rulesCategory, rule, null);
    }

    public MeasureKey(FileMeasure measure) {
        this(measure.getMetric(), measure.getRulesCategory(), measure.getRule(), measure.getFile());
    }

    public MeasureKey(ProjectMeasure measure) {
        this(measure.getMetric(), measure.getRulesCategory(), measure.getRule(), null);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MeasureKey)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MeasureKey other = (MeasureKey)obj;
        return new EqualsBuilder().append((Object)this.file, (Object)other.file).append((Object)this.metric, (Object)other.metric).append((Object)this.rulesCategory, (Object)other.rulesCategory).append((Object)this.rule, (Object)other.rule).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.file).append((Object)this.metric).append((Object)this.rulesCategory).append((Object)this.rule).toHashCode();
    }

    public Object clone() {
        return new MeasureKey(this.metric, this.rulesCategory, this.rule, this.file);
    }

    public File getFile() {
        return this.file;
    }

    public MeasureKey setFile(File file) {
        this.file = file;
        return this;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public MeasureKey setMetric(Metric metric) {
        this.metric = metric;
        return this;
    }

    public RulesCategory getRulesCategory() {
        return this.rulesCategory;
    }

    public MeasureKey setRulesCategory(RulesCategory rulesCategory) {
        this.rulesCategory = rulesCategory;
        return this;
    }

    public Rule getRule() {
        return this.rule;
    }

    public MeasureKey setRule(Rule rule) {
        this.rule = rule;
        return this;
    }
}

