/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.service;

import ch.hortis.sonar.model.MavenProject;
import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.Metrics;
import ch.hortis.sonar.model.ProjectMeasure;
import ch.hortis.sonar.service.MeasureKey;
import ch.hortis.sonar.service.MetricService;
import ch.hortis.sonar.service.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectMeasureService
extends Service {
    public ProjectMeasureService(EntityManager manager) {
        super(manager);
    }

    public Map<MeasureKey, List<ProjectMeasure>> getHistory(MavenProject project, Metrics[] metrics) {
        MetricService metricsService = new MetricService(this.manager);
        ArrayList<Metric> targets = new ArrayList<Metric>();
        for (Metrics target : metrics) {
            targets.add(metricsService.getMetric(target));
        }
        Query query = this.manager.createNamedQuery("ProjectMeasure.selectHistory");
        query.setParameter("project", (Object)project);
        query.setParameter("metrics", targets);
        HashMap<MeasureKey, List<ProjectMeasure>> result = new HashMap<MeasureKey, List<ProjectMeasure>>();
        List measures = query.getResultList();
        for (ProjectMeasure measure : measures) {
            MeasureKey key = new MeasureKey(measure);
            List<ProjectMeasure> sublist = result.get(key);
            if (sublist == null) {
                sublist = new ArrayList<ProjectMeasure>();
                result.put(key, sublist);
            }
            sublist.add(measure);
        }
        return result;
    }
}

