/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.service;

import ch.hortis.sonar.model.File;
import ch.hortis.sonar.model.Rule;
import ch.hortis.sonar.model.RuleFailure;
import ch.hortis.sonar.model.RuleFailureLevel;
import ch.hortis.sonar.model.RulesCategory;
import ch.hortis.sonar.model.Snapshot;
import ch.hortis.sonar.service.Service;
import java.util.List;
import javax.persistence.EntityManager;

public class RuleFailureService
extends Service {
    public RuleFailureService(EntityManager manager) {
        super(manager);
    }

    public Long getRuleFailuresCount(Snapshot snapshot, RuleFailureLevel ruleFailureLevel) {
        long count = 0L;
        List<RuleFailure> failures = snapshot.getRuleFailures();
        for (RuleFailure failure : failures) {
            if (failure.getFile() != null || failure.getLevel() != ruleFailureLevel) continue;
            ++count;
        }
        return count;
    }

    public Long getRuleFailuresCount(Snapshot snapshot, File file, RuleFailureLevel ruleFailureLevel) {
        long count = 0L;
        List<RuleFailure> failures = snapshot.getRuleFailures();
        for (RuleFailure failure : failures) {
            if (failure.getFile() == null || !failure.getFile().getId().equals(file.getId()) || failure.getLevel() != ruleFailureLevel) continue;
            ++count;
        }
        return count;
    }

    public Long getRuleFailuresCount(Snapshot snapshot, RulesCategory category, RuleFailureLevel ruleFailureLevel) {
        long count = 0L;
        List<RuleFailure> failures = snapshot.getRuleFailures();
        for (RuleFailure failure : failures) {
            if (failure.getFile() != null || !failure.getRule().getRulesCategory().getId().equals(category.getId()) || failure.getLevel() != ruleFailureLevel) continue;
            ++count;
        }
        return count;
    }

    public Long getRuleFailuresCount(Snapshot snapshot, Rule rule, RuleFailureLevel ruleFailureLevel) {
        long count = 0L;
        List<RuleFailure> failures = snapshot.getRuleFailures();
        for (RuleFailure failure : failures) {
            if (failure.getFile() != null || !failure.getRule().getId().equals(rule.getId()) || failure.getLevel() != ruleFailureLevel) continue;
            ++count;
        }
        return count;
    }
}

