/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.service;

import ch.hortis.sonar.model.Rule;
import ch.hortis.sonar.model.RulesCategory;
import ch.hortis.sonar.service.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesService
extends Service {
    private Collection<Rule> rules;
    private Map<String, Rule> rulesByPluginKey;
    private Collection<RulesCategory> rulesCategories;

    public RulesService(EntityManager manager) {
        super(manager);
    }

    public Collection<Rule> getRules() {
        if (this.rules == null) {
            Query query = this.manager.createNamedQuery("Rule.selectAll");
            query.setFlushMode(FlushModeType.COMMIT);
            this.rules = query.getResultList();
        }
        return this.rules;
    }

    public Collection<Rule> getRulesByCategory(RulesCategory categ) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (Rule rule : this.getRules()) {
            if (!rule.getRulesCategory().equals(categ)) continue;
            result.add(rule);
        }
        return result;
    }

    public Collection<RulesCategory> getRulesCategories() {
        if (this.rulesCategories == null) {
            Query query = this.manager.createNamedQuery("RulesCategory.selectAll");
            query.setFlushMode(FlushModeType.COMMIT);
            this.rulesCategories = query.getResultList();
        }
        return this.rulesCategories;
    }

    public Rule getRuleByPluginKey(String key) {
        if (this.rulesByPluginKey == null) {
            this.rulesByPluginKey = new HashMap<String, Rule>();
            Collection<Rule> rules = this.getRules();
            for (Rule rule : rules) {
                this.rulesByPluginKey.put(rule.getPluginRuleKey(), rule);
            }
        }
        return this.rulesByPluginKey.get(key);
    }
}

