/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.service;

import ch.hortis.sonar.model.MavenProject;
import ch.hortis.sonar.model.SnapshotGroup;
import ch.hortis.sonar.service.MavenProjectService;
import ch.hortis.sonar.service.Service;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotGroupService
extends Service {
    public SnapshotGroupService(EntityManager manager) {
        super(manager);
    }

    public SnapshotGroup getLastProcessedSnapshotGroup(Integer projectId) throws NoResultException {
        Query query = this.manager.createNamedQuery("SnapshotGroup.selectLastProcessed");
        query.setParameter("idProject", (Object)projectId);
        return (SnapshotGroup)query.getSingleResult();
    }

    public SnapshotGroup getLastUnprocessedGroup(Integer projectId, long delayInMs, long roofTime) throws NoResultException {
        Query query = this.manager.createNamedQuery("SnapshotGroup.selectLast");
        query.setParameter("idProject", (Object)projectId);
        List snapshot = query.getResultList();
        if (snapshot.isEmpty()) {
            throw new NoResultException();
        }
        roofTime += delayInMs;
        for (Object aSnapshot : snapshot) {
            SnapshotGroup grp = (SnapshotGroup)aSnapshot;
            if (grp.getCreatedAt().getTime() >= roofTime) continue;
            return grp;
        }
        throw new NoResultException();
    }

    public Collection<SnapshotGroup> getUnprocessedGroups() {
        Query query = this.manager.createNamedQuery("SnapshotGroup.selectUnprocessed");
        List list = query.getResultList();
        this.log.debug("Selected unprocessed snapshot groups : " + list.size());
        return list;
    }

    public boolean isReadyToCalculateMeasures(Integer groupId, MavenProjectService projectService) {
        return this.isReadyToCalculateMeasures((SnapshotGroup)this.manager.find(SnapshotGroup.class, (Object)groupId), projectService);
    }

    public boolean isReadyToCalculateMeasures(SnapshotGroup group, MavenProjectService projectService) {
        boolean ready = false;
        if (!group.getProcessed().booleanValue()) {
            if (projectService == null) {
                projectService = new MavenProjectService(this.manager);
            }
            MavenProject rootProject = group.getMavenProject();
            Collection<MavenProject> modules = projectService.getModules(rootProject, true);
            if (group.getSnapshots().size() == modules.size() + 1) {
                ready = true;
            }
        }
        return ready;
    }
}

