/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.service;

import ch.hortis.sonar.service.WebInterfaceService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WebInterfaceServiceImpl
implements WebInterfaceService {
    private String remoteHostURL;
    protected static final int DOWNLOAD_FAILURE_RETRY_COUNT = 3;
    private static Map<String, byte[]> remotesFilesCache = Collections.synchronizedMap(new HashMap());
    private static final int CONNECT_TIMEOUT_MILLISECONDS = 30000;
    private static final int READ_TIMEOUT_MILLISECONDS = 60000;

    public WebInterfaceServiceImpl(String remoteHostURL) {
        this.remoteHostURL = remoteHostURL;
        if (this.remoteHostURL.endsWith("/")) {
            this.remoteHostURL = StringUtils.chop((String)this.remoteHostURL);
        }
    }

    public void getRemoteCheckstyleConfiguration(File target) throws IOException {
        this.callRemoteFile("/rules_config/checkstyle.xml", target, true);
    }

    public void getRemotePMDConfiguration(File target) throws IOException {
        this.callRemoteFile("/rules_config/pmd.xml", target, true);
    }

    public void triggerMeasuresCalculations() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.callRemoteFile("/batch_job/measures_calculations", out, false);
    }

    public InputStream getRemoteFile(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(60000);
        conn.connect();
        return conn.getInputStream();
    }

    public static void resetCache() {
        remotesFilesCache.clear();
    }

    private void callRemoteFile(String filePathOnServer, OutputStream target, boolean useCache) throws IOException {
        String fullFileURL = this.remoteHostURL + filePathOnServer;
        try {
            int readen;
            InputStream in = null;
            if (useCache && remotesFilesCache.containsKey(filePathOnServer)) {
                in = new ByteArrayInputStream(remotesFilesCache.get(filePathOnServer));
            } else {
                int retryCount = 0;
                while (in == null) {
                    try {
                        in = this.getRemoteFile(new URL(fullFileURL));
                    }
                    catch (IOException ex) {
                        if (++retryCount != 3) continue;
                        throw ex;
                    }
                }
                if (useCache) {
                    target = new CacheInterceptorOutputStream(target, remotesFilesCache, filePathOnServer);
                }
            }
            byte[] buffer = new byte[512];
            while ((readen = in.read(buffer)) != -1) {
                target.write(buffer, 0, readen);
            }
            in.close();
            target.close();
        }
        catch (IOException ex) {
            IOException ioEx = new IOException("Error occured during file " + fullFileURL + " download");
            ioEx.initCause(ex);
            throw ioEx;
        }
    }

    private void callRemoteFile(String filePathOnServer, File target, boolean useCache) throws IOException {
        FileOutputStream out = new FileOutputStream(target);
        this.callRemoteFile(filePathOnServer, out, useCache);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheInterceptorOutputStream
    extends OutputStream {
        private Map<String, byte[]> cache;
        private ByteArrayOutputStream cacheContent;
        private OutputStream intercepted;
        private String cacheKey;

        private CacheInterceptorOutputStream(OutputStream intercepted, Map<String, byte[]> cache, String cacheKey) {
            this.cache = cache;
            this.intercepted = intercepted;
            this.cacheKey = cacheKey;
            this.cacheContent = new ByteArrayOutputStream();
        }

        @Override
        public void close() throws IOException {
            this.intercepted.close();
            this.cache.put(this.cacheKey, this.cacheContent.toByteArray());
            this.cacheContent.close();
        }

        @Override
        public void flush() throws IOException {
            this.intercepted.flush();
            this.cacheContent.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.intercepted.write(b, off, len);
            this.cacheContent.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.intercepted.write(b);
            this.cacheContent.write(b);
        }

        @Override
        public void write(int b) throws IOException {
            this.intercepted.write(b);
            this.cacheContent.write(b);
        }
    }
}

