/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.boolex;

import ch.qos.logback.access.boolex.JaninoEventEvaluator;
import ch.qos.logback.access.dummy.DummyRequest;
import ch.qos.logback.access.dummy.DummyResponse;
import ch.qos.logback.access.dummy.DummyServerAdapter;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.boolex.EvaluationException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JaninoEventEvaluatorTest {
    final String expectedURL1 = "testUrl1";
    final String expectedURL2 = "testUrl2";
    JaninoEventEvaluator evaluator;
    DummyRequest request;
    DummyResponse response;
    DummyServerAdapter serverAdapter;
    AccessContext accessContext = new AccessContext();

    @Before
    public void setUp() throws Exception {
        this.evaluator = new JaninoEventEvaluator();
        this.evaluator.setContext((Context)this.accessContext);
        this.request = new DummyRequest();
        this.response = new DummyResponse();
        this.serverAdapter = new DummyServerAdapter(this.request, this.response);
    }

    @Test
    public void smoke() throws EvaluationException {
        this.evaluator.setExpression("event.getProtocol().equals(\"testProtocol\")");
        this.evaluator.start();
        AccessEvent ae = new AccessEvent((Context)this.accessContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response, (ServerAdapter)this.serverAdapter);
        Assert.assertTrue((boolean)this.evaluator.evaluate((Object)ae));
    }

    @Test
    public void block() throws EvaluationException {
        this.evaluator.setExpression("String protocol = event.getProtocol();return protocol.equals(\"testProtocol\");");
        this.evaluator.start();
        AccessEvent ae = new AccessEvent((Context)this.accessContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response, (ServerAdapter)this.serverAdapter);
        Assert.assertTrue((boolean)this.evaluator.evaluate((Object)ae));
    }

    @Test
    public void invalidExpression() throws EvaluationException {
        this.evaluator.setExpression("return true");
        this.evaluator.start();
        AccessEvent ae = new AccessEvent((Context)this.accessContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response, (ServerAdapter)this.serverAdapter);
        try {
            this.evaluator.evaluate((Object)ae);
            Assert.fail((String)"Was expecting an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

