/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.JettyFixtureWithListAndConsoleAppenders;
import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.spi.Util;
import ch.qos.logback.access.testUtil.NotifyingListAppender;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JettyBasicTest {
    static RequestLogImpl REQUEST_LOG_IMPL;
    static JettyFixtureWithListAndConsoleAppenders JETTY_FIXTURE;
    private static final int TIMEOUT = 5;
    static int RANDOM_SERVER_PORT;

    @BeforeAll
    public static void startServer() throws Exception {
        REQUEST_LOG_IMPL = new RequestLogImpl();
        JETTY_FIXTURE = new JettyFixtureWithListAndConsoleAppenders(REQUEST_LOG_IMPL, RANDOM_SERVER_PORT);
        JETTY_FIXTURE.start();
    }

    @AfterAll
    public static void stopServer() throws Exception {
        if (JETTY_FIXTURE != null) {
            JETTY_FIXTURE.stop();
        }
    }

    @Test
    public void getRequest() throws Exception {
        URL url = new URL("http://localhost:" + RANDOM_SERVER_PORT + "/");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        String result = Util.readToString((InputStream)connection.getInputStream());
        Assertions.assertEquals((Object)"hello world", (Object)result);
        NotifyingListAppender listAppender = (NotifyingListAppender)REQUEST_LOG_IMPL.getAppender("list");
        listAppender.list.clear();
    }

    @Test
    public void eventGoesToAppenders() throws Exception {
        URL url = new URL(JETTY_FIXTURE.getUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        String result = Util.readToString((InputStream)connection.getInputStream());
        Assertions.assertEquals((Object)"hello world", (Object)result);
        NotifyingListAppender listAppender = (NotifyingListAppender)REQUEST_LOG_IMPL.getAppender("list");
        IAccessEvent event = listAppender.list.poll(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)event, (String)"No events received");
        Assertions.assertEquals((Object)"127.0.0.1", (Object)event.getRemoteHost());
        Assertions.assertEquals((Object)"localhost", (Object)event.getServerName());
        listAppender.list.clear();
    }

    @Test
    public void postContentConverter() throws Exception {
        URL url = new URL(JETTY_FIXTURE.getUrl());
        String msg = "test message";
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setFixedLengthStreamingMode(msg.getBytes().length);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "text/plain");
        PrintWriter output = new PrintWriter(new OutputStreamWriter(connection.getOutputStream()));
        output.print(msg);
        output.flush();
        output.close();
        NotifyingListAppender listAppender = (NotifyingListAppender)REQUEST_LOG_IMPL.getAppender("list");
        IAccessEvent event = listAppender.list.poll(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)event, (String)"No events received");
    }

    static {
        RANDOM_SERVER_PORT = RandomUtil.getRandomServerPort();
    }
}

