/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.RequestLogImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class JettyFixtureBase {
    protected final RequestLogImpl requestLogImpl;
    protected Handler handler = new BasicHandler();
    private final int port;
    Server server;
    protected String url;

    public JettyFixtureBase(RequestLogImpl impl, int port) {
        this.requestLogImpl = impl;
        this.port = port;
        this.url = "http://localhost:" + port + "/";
    }

    public String getName() {
        return "Jetty Test Setup";
    }

    public String getUrl() {
        return this.url;
    }

    public void start() throws Exception {
        this.server = new Server(this.port);
        this.server.setRequestLog((RequestLog)this.requestLogImpl);
        this.configureRequestLogImpl();
        this.server.setHandler(this.getRequestHandler());
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.server = null;
    }

    protected void configureRequestLogImpl() {
        this.requestLogImpl.start();
    }

    protected Handler getRequestHandler() {
        return this.handler;
    }

    class BasicHandler
    extends AbstractHandler {
        BasicHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/plain");
            PrintWriter writer = response.getWriter();
            ((Writer)writer).write("hello world");
            ((Writer)writer).flush();
            baseRequest.setHandled(true);
        }
    }
}

