/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.joran;

import ch.qos.logback.access.dummy.DummyAccessEventBuilder;
import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.testUtil.StringListAppender;
import ch.qos.logback.core.util.StatusPrinter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JoranConfiguratorTest {
    AccessContext context = new AccessContext();

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.context);
        jc.doConfigure(file);
    }

    @Test
    public void smoke() throws Exception {
        this.configure("src/test/input/joran/smoke.xml");
        StatusPrinter.print((Context)this.context);
        ListAppender listAppender = (ListAppender)this.context.getAppender("LIST");
        Assertions.assertNotNull((Object)listAppender);
        IAccessEvent event = DummyAccessEventBuilder.buildNewAccessEvent();
        listAppender.doAppend((Object)event);
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
        IAccessEvent ae = (IAccessEvent)listAppender.list.get(0);
        Assertions.assertNotNull((Object)ae);
    }

    @Test
    public void defaultLayout() throws Exception {
        this.configure("src/test/input/joran/defaultLayout.xml");
        StringListAppender listAppender = (StringListAppender)this.context.getAppender("STR_LIST");
        IAccessEvent event = DummyAccessEventBuilder.buildNewAccessEvent();
        listAppender.doAppend((Object)event);
        Assertions.assertEquals((int)1, (int)listAppender.strList.size());
        Assertions.assertTrue((boolean)((String)listAppender.strList.get(0)).startsWith("testMethod"));
    }
}

