/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.net;

import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.net.SocketNode;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.ServerSocket;
import java.net.Socket;

public class SimpleSocketServer {
    static int port;
    private static AccessContext basicContext;

    public static void main(String[] argv) throws Exception {
        if (argv.length == 2) {
            SimpleSocketServer.init(argv[0], argv[1]);
        } else {
            SimpleSocketServer.usage("Wrong number of arguments.");
        }
        SimpleSocketServer.runServer();
    }

    static void runServer() {
        try {
            System.out.println("Listening on port " + port);
            ServerSocket serverSocket = new ServerSocket(port);
            while (true) {
                System.out.println("Waiting to accept a new client.");
                Socket socket = serverSocket.accept();
                System.out.println("Connected to client at " + String.valueOf(socket.getInetAddress()));
                System.out.println("Starting new socket node.");
                new Thread(new SocketNode(socket, basicContext)).start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java " + SimpleSocketServer.class.getName() + " port configFile");
        System.exit(1);
    }

    static void init(String portStr, String configFile) throws JoranException {
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            SimpleSocketServer.usage("Could not interpret port number [" + portStr + "].");
        }
        basicContext = new AccessContext();
        if (configFile.endsWith(".xml")) {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)basicContext);
            configurator.doConfigure(configFile);
            StatusPrinter.print((Context)basicContext);
        }
    }
}

