/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicStatusManager
implements StatusManager {
    public static final int MAX_COUNT = 200;
    int count = 0;
    final List<Status> statusList = Collections.synchronizedList(new ArrayList());
    int level = 0;
    final List<StatusListener> statusListenerList = Collections.synchronizedList(new ArrayList());

    @Override
    public void add(Status newStatus) {
        if (this.count > 200) {
            return;
        }
        ++this.count;
        if (newStatus.getLevel() > this.level) {
            this.level = newStatus.getLevel();
        }
        this.statusList.add(newStatus);
        this.fireStatusAddEvent(newStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStatusAddEvent(Status status) {
        List<StatusListener> list = this.statusListenerList;
        synchronized (list) {
            for (StatusListener sl : this.statusListenerList) {
                sl.addStatusEvent(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Status> getCopyOfStatusList() {
        List<Status> list = this.statusList;
        synchronized (list) {
            return new ArrayList<Status>(this.statusList);
        }
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void add(StatusListener listener) {
        this.statusListenerList.add(listener);
    }

    @Override
    public void remove(StatusListener listener) {
        this.statusListenerList.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StatusListener> getCopyOfStatusListenerList() {
        List<StatusListener> list = this.statusListenerList;
        synchronized (list) {
            return new ArrayList<StatusListener>(this.statusListenerList);
        }
    }
}

