/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Runner;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.ResilienceUtil;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class FileAppenderResilienceTest {
    FileAppender<Object> fa = new FileAppender();
    Context context = new ContextBase();
    int diff = RandomUtil.getPositiveInt();
    String outputDirStr = "target/test-output/resilience-" + this.diff + "/";
    String logfileStr = this.outputDirStr + "output.log";

    @Before
    public void setUp() throws InterruptedException {
        this.context.getStatusManager().add((StatusListener)new OnConsoleStatusListener());
        File outputDir = new File(this.outputDirStr);
        outputDir.mkdirs();
        this.fa.setContext(this.context);
        this.fa.setName("FILE");
        this.fa.setEncoder((Encoder)new EchoEncoder());
        this.fa.setFile(this.logfileStr);
        this.fa.start();
    }

    @Test
    @Ignore
    public void manual() throws InterruptedException, IOException {
        Runner runner = new Runner(this.fa);
        Thread t = new Thread(runner);
        t.start();
        while (true) {
            Thread.sleep(110L);
        }
    }

    @Test
    public void smoke() throws InterruptedException, IOException {
        Runner runner = new Runner(this.fa);
        Thread t = new Thread(runner);
        t.start();
        double delayCoeff = 2.0;
        for (int i = 0; i < 5; ++i) {
            Thread.sleep((int)(100.0 * delayCoeff));
            ResilientFileOutputStream resilientFOS = (ResilientFileOutputStream)this.fa.getOutputStream();
            FileChannel fileChannel = resilientFOS.getChannel();
            fileChannel.close();
        }
        runner.setDone(true);
        t.join();
        double bestCase = 1.0 / delayCoeff;
        ResilienceUtil.verify(this.logfileStr, "^hello (\\d{1,5})$", runner.getCounter(), bestCase);
    }
}

