/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.implicitAction;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.SimpleConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.implicitAction.Cake;
import ch.qos.logback.core.joran.implicitAction.Fruit;
import ch.qos.logback.core.joran.implicitAction.FruitContext;
import ch.qos.logback.core.joran.implicitAction.FruitContextAction;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImplicitActionTest {
    static final String IMPLCIT_DIR = "src/test/input/joran/implicitAction/";
    FruitContext fruitContext = new FruitContext();
    SimpleConfigurator simpleConfigurator;

    @Before
    public void setUp() throws Exception {
        this.fruitContext.setName("fruits");
        HashMap<Pattern, Action> rulesMap = new HashMap<Pattern, Action>();
        rulesMap.put(new Pattern("/context/"), new FruitContextAction());
        this.simpleConfigurator = new SimpleConfigurator(rulesMap);
        this.simpleConfigurator.setContext((Context)this.fruitContext);
    }

    void verifyFruit() {
        List<Fruit> fList = this.fruitContext.getFruitList();
        Assert.assertNotNull(fList);
        Assert.assertEquals((long)1L, (long)fList.size());
        Fruit f0 = fList.get(0);
        Assert.assertEquals((Object)"blue", (Object)f0.getName());
        Assert.assertEquals((long)2L, (long)f0.textList.size());
        Assert.assertEquals((Object)"hello", (Object)f0.textList.get(0));
        Assert.assertEquals((Object)"world", (Object)f0.textList.get(1));
    }

    @Test
    public void nestedComplex() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplex.xml");
            this.verifyFruit();
        }
        catch (Exception je) {
            StatusPrinter.print((Context)this.fruitContext);
            throw je;
        }
    }

    @Test
    public void nestedComplexWithoutClassAtrribute() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplexWithoutClassAtrribute.xml");
            this.verifyFruit();
        }
        catch (Exception je) {
            StatusPrinter.print((Context)this.fruitContext);
            throw je;
        }
    }

    void verifyFruitList() {
        List<Fruit> fList = this.fruitContext.getFruitList();
        Assert.assertNotNull(fList);
        Assert.assertEquals((long)1L, (long)fList.size());
        Fruit f0 = fList.get(0);
        Assert.assertEquals((long)2L, (long)f0.cakeList.size());
        Cake cakeA = f0.cakeList.get(0);
        Assert.assertEquals((Object)"A", (Object)cakeA.getType());
        Cake cakeB = f0.cakeList.get(1);
        Assert.assertEquals((Object)"B", (Object)cakeB.getType());
    }

    @Test
    public void nestedComplexCollection() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplexCollection.xml");
            this.verifyFruitList();
        }
        catch (Exception je) {
            StatusPrinter.print((Context)this.fruitContext);
            throw je;
        }
    }

    @Test
    public void nestedComplexCollectionWithoutClassAtrribute() throws Exception {
        try {
            this.simpleConfigurator.doConfigure("src/test/input/joran/implicitAction/nestedComplexCollectionWithoutClassAtrribute.xml");
            this.verifyFruitList();
        }
        catch (Exception je) {
            StatusPrinter.print((Context)this.fruitContext);
            throw je;
        }
    }
}

