/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.ContextBase;
import org.junit.Assert;
import org.junit.Test;

public class ContextBaseTest {
    ContextBase context = new ContextBase();

    @Test
    public void renameDefault() {
        this.context.setName("default");
        this.context.setName("hello");
    }

    @Test
    public void idempotentNameTest() {
        this.context.setName("hello");
        this.context.setName("hello");
    }

    @Test
    public void renameTest() {
        this.context.setName("hello");
        try {
            this.context.setName("x");
            Assert.fail((String)"renaming is not allowed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void resetTest() {
        this.context.setName("hello");
        this.context.putProperty("keyA", "valA");
        this.context.putObject("keyA", (Object)"valA");
        Assert.assertEquals((Object)"valA", (Object)this.context.getProperty("keyA"));
        Assert.assertEquals((Object)"valA", (Object)this.context.getObject("keyA"));
        this.context.reset();
        Assert.assertNull((Object)this.context.getProperty("keyA"));
        Assert.assertNull((Object)this.context.getObject("keyA"));
    }
}

