/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.conditional;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.conditional.Condition;
import ch.qos.logback.core.joran.conditional.PropertyEvalScriptBuilder;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertyEvalScriptBuilderTest {
    Context context = new ContextBase();
    PropertyEvalScriptBuilder pesb = new PropertyEvalScriptBuilder();
    int diff = RandomUtil.getPositiveInt();

    @Before
    public void setUp() {
        this.context.setName("c" + this.diff);
        this.pesb.setContext(this.context);
    }

    @Test
    public void existing() throws Exception {
        String k = "ka" + this.diff;
        this.context.putProperty("ka" + this.diff, "va");
        Condition condition = this.pesb.build("p(\"" + k + "\").contains(\"va\")");
        Assert.assertNotNull((Object)condition);
        Assert.assertTrue((boolean)condition.evaluate());
    }

    @Test
    public void isNullForExisting() throws Exception {
        String k = "ka" + this.diff;
        this.context.putProperty("ka" + this.diff, "va");
        Condition condition = this.pesb.build("isNull(\"" + k + "\")");
        Assert.assertNotNull((Object)condition);
        Assert.assertFalse((boolean)condition.evaluate());
    }

    @Test
    public void inexistentProperty() throws Exception {
        String k = "ka" + this.diff;
        Condition condition = this.pesb.build("p(\"" + k + "\").contains(\"va\")");
        Assert.assertNotNull((Object)condition);
        Assert.assertFalse((boolean)condition.evaluate());
    }

    @Test
    public void isNullForInexistent() throws Exception {
        String k = "ka" + this.diff;
        Condition condition = this.pesb.build("isNull(\"" + k + "\")");
        Assert.assertNotNull((Object)condition);
        Assert.assertTrue((boolean)condition.evaluate());
    }

    @Test
    public void nameOK() throws Exception {
        Condition condition = this.pesb.build("name.contains(\"" + this.context.getName() + "\")");
        Assert.assertNotNull((Object)condition);
        Assert.assertTrue((boolean)condition.evaluate());
    }

    @Test
    public void wrongName() throws Exception {
        Condition condition = this.pesb.build("name.contains(\"x\")");
        Assert.assertNotNull((Object)condition);
        Assert.assertFalse((boolean)condition.evaluate());
    }
}

