/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.Converter123;
import ch.qos.logback.core.pattern.ConverterHello;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.status.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerTest {
    Map<String, String> converterMap = new HashMap<String, String>();
    Context context = new ContextBase();

    @Before
    public void setUp() {
        this.converterMap.put("OTT", Converter123.class.getName());
        this.converterMap.put("hello", ConverterHello.class.getName());
        this.converterMap.putAll(Parser.DEFAULT_COMPOSITE_CONVERTER_MAP);
    }

    String write(Converter<Object> head, Object event) {
        StringBuilder buf = new StringBuilder();
        for (Converter c = head; c != null; c = c.getNext()) {
            c.write(buf, event);
        }
        return buf.toString();
    }

    @Test
    public void testLiteral() throws Exception {
        Parser p = new Parser("hello");
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"hello", (Object)result);
    }

    @Test
    public void testBasic() throws Exception {
        Parser p = new Parser("abc %hello");
        p.setContext(this.context);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"abc Hello", (Object)result);
        p = new Parser("abc %hello %OTT");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"abc Hello 123", (Object)result);
    }

    @Test
    public void testFormat() throws Exception {
        Parser p = new Parser("abc %7hello");
        p.setContext(this.context);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"abc   Hello", (Object)result);
        p = new Parser("abc %-7hello");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"abc Hello  ", (Object)result);
        p = new Parser("abc %.3hello");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"abc llo", (Object)result);
        p = new Parser("abc %.-3hello");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"abc Hel", (Object)result);
        p = new Parser("abc %4.5OTT");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"abc  123", (Object)result);
        p = new Parser("abc %-4.5OTT");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"abc 123 ", (Object)result);
        p = new Parser("abc %3.4hello");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"abc ello", (Object)result);
        p = new Parser("abc %-3.-4hello");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"abc Hell", (Object)result);
    }

    @Test
    public void testComposite() throws Exception {
        ContextBase c = new ContextBase();
        Parser p = new Parser("%(ABC %hello)");
        p.setContext((Context)c);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        StatusPrinter.print((Context)c);
        Assert.assertEquals((Object)"ABC Hello", (Object)result);
        Parser p2 = new Parser("%(ABC %hello)");
        p2.setContext(this.context);
        Node t2 = p2.parse();
        Converter head2 = p2.compile(t2, this.converterMap);
        String result2 = this.write((Converter<Object>)head2, new Object());
        Assert.assertEquals((Object)"ABC Hello", (Object)result2);
    }

    @Test
    public void testCompositeFormatting() throws Exception {
        Parser p = new Parser("xyz %4.10(ABC)");
        p.setContext(this.context);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"xyz  ABC", (Object)result);
        p = new Parser("xyz %-4.10(ABC)");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"xyz ABC ", (Object)result);
        p = new Parser("xyz %.2(ABC %hello)");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"xyz lo", (Object)result);
        p = new Parser("xyz %.-2(ABC)");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"xyz AB", (Object)result);
        p = new Parser("xyz %30.30(ABC %20hello)");
        p.setContext(this.context);
        t = p.parse();
        head = p.compile(t, this.converterMap);
        result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"xyz       ABC                Hello", (Object)result);
    }

    @Test
    public void testUnknownWord() throws Exception {
        Parser p = new Parser("%unknown");
        p.setContext(this.context);
        Node t = p.parse();
        p.compile(t, this.converterMap);
        StatusChecker chercker = new StatusChecker(this.context.getStatusManager());
        Assert.assertTrue((boolean)chercker.containsMatch("\\[unknown] is not a valid conversion word"));
    }

    @Test
    public void testWithNopEscape() throws Exception {
        Parser p = new Parser("xyz %hello\\_world");
        p.setContext(this.context);
        Node t = p.parse();
        Converter head = p.compile(t, this.converterMap);
        String result = this.write((Converter<Object>)head, new Object());
        Assert.assertEquals((Object)"xyz Helloworld", (Object)result);
    }
}

