/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.testUtil.FileToBufferUtil;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaffoldingForRollingTests {
    public static final String DATE_PATTERN_WITH_SECONDS = "yyyy-MM-dd_HH_mm_ss";
    public static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
    int diff = RandomUtil.getPositiveInt();
    protected String randomOutputDir = "target/test-output/" + this.diff + "/";
    EchoEncoder<Object> encoder = new EchoEncoder();
    Context context = new ContextBase();
    protected List<String> expectedFilenameList = new ArrayList<String>();
    protected long nextRolloverThreshold;
    protected long currentTime;
    Calendar cal = Calendar.getInstance();

    public void setUp() {
        this.context.setName("test");
        this.cal.set(14, 333);
        this.currentTime = this.cal.getTimeInMillis();
        this.recomputeRolloverThreshold(this.currentTime);
    }

    public static void existenceCheck(String filename) {
        Assert.assertTrue((String)("File " + filename + " does not exist"), (boolean)new File(filename).exists());
    }

    public static File[] getFilesInDirectory(String outputDirStr) {
        File outputDir = new File(outputDirStr);
        return outputDir.listFiles();
    }

    public static void fileContentCheck(File[] fileArray, int runLength, String prefix) throws IOException {
        ArrayList<String> stringList = new ArrayList<String>();
        for (File file : fileArray) {
            FileToBufferUtil.readIntoList(file, stringList);
        }
        ArrayList<String> witnessList = new ArrayList<String>();
        for (int i = 0; i < runLength; ++i) {
            witnessList.add(prefix + i);
        }
        Assert.assertEquals(witnessList, stringList);
    }

    public static void sortedContentCheck(String outputDirStr, int runLength, String prefix) throws IOException {
        File[] fileArray = ScaffoldingForRollingTests.getFilesInDirectory(outputDirStr);
        FileFilterUtil.sortFileArrayByName((File[])fileArray);
        ScaffoldingForRollingTests.fileContentCheck(fileArray, runLength, prefix);
    }

    public static void reverseSortedContentCheck(String outputDirStr, int runLength, String prefix) throws IOException {
        File[] fileArray = ScaffoldingForRollingTests.getFilesInDirectory(outputDirStr);
        FileFilterUtil.reverseSortFileArrayByName((File[])fileArray);
        ScaffoldingForRollingTests.fileContentCheck(fileArray, runLength, prefix);
    }

    public static void existenceCheck(List<String> filenameList) {
        for (String filename : filenameList) {
            Assert.assertTrue((String)("File " + filename + " does not exist"), (boolean)new File(filename).exists());
        }
    }

    public static int existenceCount(List<String> filenameList) {
        int existenceCounter = 0;
        for (String filename : filenameList) {
            if (!new File(filename).exists()) continue;
            ++existenceCounter;
        }
        return existenceCounter;
    }

    String testId2FileName(String testId) {
        return this.randomOutputDir + testId + ".log";
    }

    protected void recomputeRolloverThreshold(long ct) {
        long delta = ct % 1000L;
        this.nextRolloverThreshold = ct - delta + 1000L;
    }

    protected boolean passThresholdTime(long nextRolloverThreshold) {
        return this.currentTime >= nextRolloverThreshold;
    }

    protected void incCurrentTime(long increment) {
        this.currentTime += increment;
    }

    protected Date getDateOfCurrentPeriodsStart() {
        long delta = this.currentTime % 1000L;
        return new Date(this.currentTime - delta);
    }

    protected Date getDateOfPreviousPeriodsStart() {
        long delta = this.currentTime % 1000L;
        return new Date(this.currentTime - delta - 1000L);
    }

    static void waitForCompression(TimeBasedRollingPolicy<Object> tbrp) throws InterruptedException, ExecutionException, TimeoutException {
        if (tbrp.future != null && !tbrp.future.isDone()) {
            tbrp.future.get(200L, TimeUnit.MILLISECONDS);
        }
    }

    protected void addExpectedFileName_ByDate(String outputDir, String testId, Date date, boolean gzExtension) {
        String fn = outputDir + testId + "-" + SDF.format(date);
        if (gzExtension) {
            fn = fn + ".gz";
        }
        this.expectedFilenameList.add(fn);
    }

    protected void addExpectedFileNamedIfItsTime_ByDate(String outputDir, String testId, boolean gzExtension) {
        if (this.passThresholdTime(this.nextRolloverThreshold)) {
            this.addExpectedFileName_ByDate(outputDir, testId, this.getDateOfCurrentPeriodsStart(), gzExtension);
            this.recomputeRolloverThreshold(this.currentTime);
        }
    }

    String addGZIfNotLast(int i) {
        int lastIndex = this.expectedFilenameList.size() - 1;
        if (i != lastIndex) {
            return ".gz";
        }
        return "";
    }
}

