/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.sift.AppenderTracker;
import ch.qos.logback.core.sift.AppenderTrackerImpl;
import ch.qos.logback.core.sift.tracker.AppenderTrackerTImpl;
import ch.qos.logback.core.sift.tracker.SimulationEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simulator {
    AppenderTrackerImpl<Object> realAppenderTracker = new AppenderTrackerImpl();
    AppenderTrackerTImpl t_appenderTracker = new AppenderTrackerTImpl();
    List<String> keySpace = new ArrayList<String>();
    List<SimulationEvent> scenario = new ArrayList<SimulationEvent>();
    Random randomKeyGen = new Random(100L);
    Random random = new Random(11234L);
    final int maxTimestampInc;
    final int inverseOfRemoveProbability;
    int i = 0;

    Simulator(int keySpaceLen, int maxTimestampInc, int inverseOfRemoveProbability) {
        this.maxTimestampInc = maxTimestampInc;
        this.inverseOfRemoveProbability = inverseOfRemoveProbability;
        HashMap<String, String> checkMap = new HashMap<String, String>();
        for (int i = 0; i < keySpaceLen; ++i) {
            String k = this.getRandomKeyStr();
            if (checkMap.containsKey(k)) {
                System.out.println("random key collision occured");
                k = k + "" + i;
            }
            this.keySpace.add(k);
            checkMap.put(k, k);
        }
    }

    private String getRandomKeyStr() {
        int ri = this.randomKeyGen.nextInt();
        String s = String.format("%X", ri);
        return s;
    }

    void buildScenario(int simLen) {
        long timestamp = 30000L;
        int keySpaceLen = this.keySpace.size();
        for (int i = 0; i < simLen; ++i) {
            int index = this.random.nextInt(keySpaceLen);
            timestamp += (long)this.random.nextInt(this.maxTimestampInc);
            String key = this.keySpace.get(index);
            SimulationEvent.SimEventType eventType = SimulationEvent.SimEventType.PUT;
            int removeNow = this.random.nextInt(this.inverseOfRemoveProbability);
            if (removeNow == 0) {
                eventType = SimulationEvent.SimEventType.REMOVE_NOW;
            }
            this.scenario.add(new SimulationEvent(eventType, key, timestamp));
        }
    }

    void dump() {
        for (SimulationEvent simeEvent : this.scenario) {
            System.out.println(simeEvent);
        }
    }

    public void simulate() {
        for (SimulationEvent simeEvent : this.scenario) {
            this.play(simeEvent, (AppenderTracker<Object>)this.realAppenderTracker);
            this.play(simeEvent, this.t_appenderTracker);
        }
    }

    void play(SimulationEvent simulationEvent, AppenderTracker<Object> appenderTracker) {
        String key = simulationEvent.key;
        long timestamp = simulationEvent.timestamp;
        switch (simulationEvent.simEventType) {
            case PUT: {
                this.doPut(appenderTracker, key, timestamp);
                break;
            }
            case REMOVE_NOW: {
                this.doRemoveNow(appenderTracker, key);
            }
        }
    }

    void doPut(AppenderTracker<Object> appenderTracker, String key, long timestamp) {
        Appender appender = appenderTracker.get(key, timestamp);
        if (appender == null) {
            appender = new NOPAppender();
            appenderTracker.put(key, appender, timestamp);
        }
        appenderTracker.stopStaleAppenders(timestamp);
    }

    void doRemoveNow(AppenderTracker<Object> appenderTracker, String key) {
        appenderTracker.stopAndRemoveNow(key);
    }
}

