/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.CyclicBufferTrackerImpl;
import junit.framework.Assert;
import org.junit.Test;

public class CyclicBufferTrackerImplTest {
    CyclicBufferTrackerImpl<Object> tracker = new CyclicBufferTrackerImpl();
    String key = "a";

    @Test
    public void empty0() {
        long now = 3000L;
        this.tracker.clearStaleBuffers(now);
        Assert.assertEquals((int)0, (int)this.tracker.keyList().size());
        Assert.assertEquals((int)0, (int)this.tracker.bufferCount);
    }

    @Test
    public void empty1() {
        long now = 3000L;
        Assert.assertNotNull((Object)this.tracker.getOrCreate(this.key, now++));
        this.tracker.clearStaleBuffers(now += 1801000L);
        Assert.assertEquals((int)0, (int)this.tracker.keyList().size());
        Assert.assertEquals((int)0, (int)this.tracker.bufferCount);
        Assert.assertNotNull((Object)this.tracker.getOrCreate(this.key, now++));
    }

    @Test
    public void smoke() {
        long now = 3000L;
        CyclicBuffer cb = this.tracker.getOrCreate(this.key, now);
        Assert.assertEquals((Object)cb, (Object)this.tracker.getOrCreate(this.key, now++));
        this.tracker.clearStaleBuffers(now += 1801000L);
        Assert.assertEquals((int)0, (int)this.tracker.keyList().size());
        Assert.assertEquals((int)0, (int)this.tracker.bufferCount);
    }

    @Test
    public void destroy() {
        long now = 3000L;
        CyclicBuffer cb = this.tracker.getOrCreate(this.key, now);
        cb.add(new Object());
        Assert.assertEquals((int)1, (int)cb.length());
        this.tracker.removeBuffer(this.key);
        Assert.assertEquals((int)0, (int)this.tracker.keyList().size());
        Assert.assertEquals((int)0, (int)this.tracker.bufferCount);
        Assert.assertEquals((int)0, (int)cb.length());
    }
}

