/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileUtilTest {
    List<File> cleanupList = new ArrayList<File>();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        for (File f : this.cleanupList) {
            f.delete();
        }
    }

    @Test
    public void smoke() {
        int diff = new Random().nextInt(100);
        File file = new File("target/test-output//fu" + diff + "/testing.txt");
        this.cleanupList.add(file);
        this.cleanupList.add(file.getParentFile());
        Assert.assertTrue((boolean)FileUtil.isParentDirectoryCreationRequired((File)file));
        Assert.assertTrue((boolean)FileUtil.createMissingParentDirectories((File)file));
        Assert.assertFalse((boolean)FileUtil.isParentDirectoryCreationRequired((File)file));
    }

    @Test
    public void smokeII() {
        int diff = new Random().nextInt(100);
        File file = new File("target/test-output//fu" + diff + "/bla/testing.txt");
        this.cleanupList.add(file);
        this.cleanupList.add(file.getParentFile());
        this.cleanupList.add(file.getParentFile().getParentFile());
        Assert.assertTrue((boolean)FileUtil.isParentDirectoryCreationRequired((File)file));
        Assert.assertTrue((boolean)FileUtil.createMissingParentDirectories((File)file));
        Assert.assertFalse((boolean)FileUtil.isParentDirectoryCreationRequired((File)file));
    }
}

