/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.IncludeModelAction;
import ch.qos.logback.core.joran.action.TopElementAction;
import ch.qos.logback.core.joran.action.ext.StackAction;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.TopModel;
import ch.qos.logback.core.model.processor.ChainedModelFilter;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.IncludeModelHandler;
import ch.qos.logback.core.model.processor.ModelFiler;
import ch.qos.logback.core.model.processor.NOPModelHandler;
import ch.qos.logback.core.testUtil.FileTestUtil;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXParseException;

public class IncludeActionTest {
    static final String INCLUDE_KEY = "includeKey";
    static final String SUB_FILE_KEY = "subFileKey";
    static final String SECOND_FILE_KEY = "secondFileKey";
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);
    TrivialConfigurator tc;
    static final String INCLUSION_DIR_PREFIX = "src/test/input/joran/inclusion/";
    static final String TOP_BY_FILE = "src/test/input/joran/inclusion/topByFile.xml";
    static final String TOP_OPTIONAL = "src/test/input/joran/inclusion/topOptional.xml";
    static final String TOP_OPTIONAL_RESOURCE = "src/test/input/joran/inclusion/topOptionalResource.xml";
    static final String INTERMEDIARY_FILE = "src/test/input/joran/inclusion/intermediaryByFile.xml";
    static final String SUB_FILE = "src/test/input/joran/inclusion/subByFile.xml";
    static final String MULTI_INCLUDE_BY_FILE = "src/test/input/joran/inclusion/multiIncludeByFile.xml";
    static final String SECOND_FILE = "src/test/input/joran/inclusion/second.xml";
    static final String TOP_BY_URL = "src/test/input/joran/inclusion/topByUrl.xml";
    static final String TOP_BY_ENTITY = "src/test/input/joran/inclusion/topByEntity.xml";
    static final String INCLUDE_BY_RESOURCE = "src/test/input/joran/inclusion/topByResource.xml";
    static final String INCLUDED_FILE = "src/test/input/joran/inclusion/included.xml";
    static final String URL_TO_INCLUDE = "file:./src/test/input/joran/inclusion/included.xml";
    static final String INVALID = "src/test/input/joran/inclusion/invalid.xml";
    static final String INCLUDED_AS_RESOURCE = "asResource/joran/inclusion/includedAsResource.xml";
    int diff = RandomUtil.getPositiveInt();
    StackAction stackAction = new StackAction();

    @Before
    public void setUp() throws Exception {
        FileTestUtil.makeTestOutputDir();
        HashMap<ElementSelector, Object> rulesMap = new HashMap<ElementSelector, Object>();
        rulesMap.put(new ElementSelector("x"), (Object)new TopElementAction());
        rulesMap.put(new ElementSelector("x/include"), new IncludeModelAction());
        rulesMap.put(new ElementSelector("x/stack"), (Object)this.stackAction);
        this.tc = new TrivialConfigurator(rulesMap){

            protected DefaultProcessor buildDefaultProcessor(Context context, InterpretationContext interpretationContext) {
                DefaultProcessor defaultProcessor = super.buildDefaultProcessor(context, interpretationContext);
                defaultProcessor.addHandler(TopModel.class, NOPModelHandler::makeInstance);
                defaultProcessor.addHandler(IncludeModel.class, IncludeModelHandler::makeInstance);
                ChainedModelFilter p1Filter = ChainedModelFilter.newInstance().allow(TopModel.class).denyAll();
                defaultProcessor.setPhaseOneFilter((ModelFiler)p1Filter);
                ChainedModelFilter p2Filter = ChainedModelFilter.newInstance().allow(TopModel.class).allow(IncludeModel.class).denyAll();
                defaultProcessor.setPhaseTwoFilter((ModelFiler)p2Filter);
                return defaultProcessor;
            }
        };
        this.tc.setContext(this.context);
    }

    @After
    public void tearDown() throws Exception {
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.context);
        this.context = null;
        System.clearProperty(INCLUDE_KEY);
        System.clearProperty(SECOND_FILE_KEY);
        System.clearProperty(SUB_FILE_KEY);
    }

    @Test
    public void basicFile() throws JoranException {
        System.setProperty(INCLUDE_KEY, INCLUDED_FILE);
        this.tc.doConfigure(TOP_BY_FILE);
        StatusPrinter.print((Context)this.context);
        this.verifyConfig(new String[]{"IA", "IB"});
    }

    @Test
    public void optionalFile() throws JoranException {
        this.tc.doConfigure(TOP_OPTIONAL);
        this.verifyConfig(new String[]{"IA", "IB"});
        StatusPrinter.print((Context)this.context);
    }

    @Test
    public void optionalResource() throws JoranException {
        this.tc.doConfigure(TOP_OPTIONAL_RESOURCE);
        this.verifyConfig(new String[]{"IA", "IB"});
        StatusPrinter.print((Context)this.context);
        Assert.assertEquals((long)0L, (long)this.statusChecker.getHighestLevel(0L));
    }

    @Test
    public void basicResource() throws JoranException {
        System.setProperty(INCLUDE_KEY, INCLUDED_AS_RESOURCE);
        this.tc.doConfigure(INCLUDE_BY_RESOURCE);
        this.verifyConfig(new String[]{"AR_A", "AR_B"});
    }

    @Test
    public void basicURL() throws JoranException {
        System.setProperty(INCLUDE_KEY, URL_TO_INCLUDE);
        this.tc.doConfigure(TOP_BY_URL);
        StatusPrinter.print((Context)this.context);
        this.verifyConfig(new String[]{"IA", "IB"});
    }

    @Test
    public void noFileFound() throws JoranException {
        System.setProperty(INCLUDE_KEY, "toto");
        this.tc.doConfigure(TOP_BY_FILE);
        Assert.assertEquals((long)1L, (long)this.statusChecker.getHighestLevel(0L));
    }

    @Test
    public void withCorruptFile() throws JoranException, IOException {
        String tmpOut = this.copyToTemp(INVALID);
        System.setProperty(INCLUDE_KEY, tmpOut);
        this.tc.doConfigure(TOP_BY_FILE);
        Assert.assertEquals((long)2L, (long)this.statusChecker.getHighestLevel(0L));
        StatusPrinter.print((Context)this.context);
        Assert.assertTrue((boolean)this.statusChecker.containsException(SAXParseException.class));
        File f = new File(tmpOut);
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((boolean)f.delete());
    }

    String copyToTemp(String in) throws IOException {
        int b;
        FileInputStream fis = new FileInputStream(in);
        String out = "target/test-output/out" + this.diff;
        FileOutputStream fos = new FileOutputStream(out);
        while ((b = fis.read()) != -1) {
            fos.write(b);
        }
        fis.close();
        fos.close();
        return out;
    }

    @Test
    public void malformedURL() throws JoranException {
        String MALFORMED = "htp://logback.qos.ch";
        System.setProperty(INCLUDE_KEY, MALFORMED);
        this.tc.doConfigure(TOP_BY_URL);
        Assert.assertEquals((long)2L, (long)this.statusChecker.getHighestLevel(0L));
        Assert.assertTrue((boolean)this.statusChecker.containsException(MalformedURLException.class));
    }

    @Test
    public void unknownURL() throws JoranException {
        System.setProperty(INCLUDE_KEY, "http://logback2345.qos.ch");
        this.tc.doConfigure(TOP_BY_URL);
        Assert.assertEquals((long)1L, (long)this.statusChecker.getHighestLevel(0L));
    }

    @Test
    public void nestedInclude() throws JoranException {
        System.setProperty(SUB_FILE_KEY, SUB_FILE);
        System.setProperty(INCLUDE_KEY, INTERMEDIARY_FILE);
        this.tc.doConfigure(TOP_BY_FILE);
        Stack<String> expected = new Stack<String>();
        expected.push("a");
        expected.push("c");
        expected.push("b");
        Assert.assertEquals(expected, this.stackAction.getStack());
    }

    @Test
    public void multiInclude() throws JoranException {
        System.setProperty(INCLUDE_KEY, INCLUDED_FILE);
        System.setProperty(SECOND_FILE_KEY, SECOND_FILE);
        this.tc.doConfigure(MULTI_INCLUDE_BY_FILE);
        this.verifyConfig(new String[]{"IA", "IB", "SECOND"});
    }

    @Test
    public void includeAsEntity() throws JoranException {
        this.tc.doConfigure(TOP_BY_ENTITY);
        this.verifyConfig(new String[0]);
    }

    void verifyConfig(String[] expected) {
        Stack<String> witness = new Stack<String>();
        witness.addAll(Arrays.asList(expected));
        Assert.assertEquals(witness, this.stackAction.getStack());
    }
}

