/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.net.AutoFlushingObjectWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

@Ignore
public class AutoFlushingObjectWriterTest {
    private InstrumentedObjectOutputStream objectOutputStream;

    @Before
    public void beforeEachTest() throws IOException {
        this.objectOutputStream = (InstrumentedObjectOutputStream)Mockito.spy((Object)new InstrumentedObjectOutputStream());
    }

    @Test
    public void writesToUnderlyingObjectOutputStream() throws IOException {
        AutoFlushingObjectWriter objectWriter = new AutoFlushingObjectWriter((ObjectOutputStream)this.objectOutputStream, 2);
        String object = "foo";
        objectWriter.write((Object)object);
        ((InstrumentedObjectOutputStream)Mockito.verify((Object)this.objectOutputStream)).writeObjectOverride(object);
    }

    @Test
    public void flushesAfterWrite() throws IOException {
        AutoFlushingObjectWriter objectWriter = new AutoFlushingObjectWriter((ObjectOutputStream)this.objectOutputStream, 2);
        String object = "foo";
        objectWriter.write((Object)object);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.objectOutputStream});
        ((InstrumentedObjectOutputStream)inOrder.verify((Object)this.objectOutputStream)).writeObjectOverride(object);
        ((InstrumentedObjectOutputStream)inOrder.verify((Object)this.objectOutputStream)).flush();
    }

    @Test
    public void resetsObjectOutputStreamAccordingToGivenResetFrequency() throws IOException {
        AutoFlushingObjectWriter objectWriter = new AutoFlushingObjectWriter((ObjectOutputStream)this.objectOutputStream, 2);
        String object = "foo";
        objectWriter.write((Object)object);
        objectWriter.write((Object)object);
        objectWriter.write((Object)object);
        objectWriter.write((Object)object);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.objectOutputStream});
        ((InstrumentedObjectOutputStream)inOrder.verify((Object)this.objectOutputStream)).writeObjectOverride(object);
        ((InstrumentedObjectOutputStream)inOrder.verify((Object)this.objectOutputStream)).writeObjectOverride(object);
        ((InstrumentedObjectOutputStream)inOrder.verify((Object)this.objectOutputStream)).reset();
        ((InstrumentedObjectOutputStream)inOrder.verify((Object)this.objectOutputStream)).writeObjectOverride(object);
        ((InstrumentedObjectOutputStream)inOrder.verify((Object)this.objectOutputStream)).writeObjectOverride(object);
        ((InstrumentedObjectOutputStream)inOrder.verify((Object)this.objectOutputStream)).reset();
    }

    private static class InstrumentedObjectOutputStream
    extends ObjectOutputStream {
        protected InstrumentedObjectOutputStream() throws IOException, SecurityException {
        }

        @Override
        protected void writeObjectOverride(Object obj) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void reset() throws IOException {
        }
    }
}

