/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.net.server.test.ServerSocketUtil;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultSocketConnectorTest {
    private static final int DELAY = 2000;
    private static final int SHORT_DELAY = 10;
    private static final int RETRY_DELAY = 10;
    private MockExceptionHandler exceptionHandler = new MockExceptionHandler();
    private ServerSocket serverSocket;
    private DefaultSocketConnector connector;
    ExecutorService executor = Executors.newSingleThreadExecutor();

    @Before
    public void setUp() throws Exception {
        this.serverSocket = ServerSocketUtil.createServerSocket();
        this.connector = new DefaultSocketConnector(this.serverSocket.getInetAddress(), this.serverSocket.getLocalPort(), 0L, 10L);
        this.connector.setExceptionHandler((SocketConnector.ExceptionHandler)this.exceptionHandler);
    }

    @After
    public void tearDown() throws Exception {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    @Test
    public void testConnect() throws Exception {
        Future connectorTask = this.executor.submit(this.connector);
        Socket socket = (Socket)connectorTask.get(2000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)socket);
        connectorTask.cancel(true);
        Assert.assertTrue((boolean)connectorTask.isDone());
        socket.close();
    }

    @Test
    public void testConnectionFails() throws Exception {
        this.serverSocket.close();
        Future connectorTask = this.executor.submit(this.connector);
        try {
            connectorTask.get(10L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Exception lastException = this.exceptionHandler.awaitConnectionFailed();
        Assert.assertTrue((boolean)(lastException instanceof ConnectException));
        Assert.assertFalse((boolean)connectorTask.isDone());
        connectorTask.cancel(true);
        Assert.assertTrue((boolean)connectorTask.isCancelled());
    }

    @Test(timeout=5000L)
    public void testConnectEventually() throws Exception {
        this.serverSocket.close();
        Future connectorTask = this.executor.submit(this.connector);
        try {
            connectorTask.get(10L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Exception lastException = this.exceptionHandler.awaitConnectionFailed();
        Assert.assertNotNull((Object)lastException);
        Assert.assertTrue((boolean)(lastException instanceof ConnectException));
        SocketAddress address = this.serverSocket.getLocalSocketAddress();
        this.serverSocket = new ServerSocket();
        this.serverSocket.setReuseAddress(true);
        this.serverSocket.bind(address);
        Socket socket = (Socket)connectorTask.get(4000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)socket);
        Assert.assertFalse((boolean)connectorTask.isCancelled());
        socket.close();
    }

    private static class MockExceptionHandler
    implements SocketConnector.ExceptionHandler {
        private final CyclicBarrier failureBarrier = new CyclicBarrier(2);
        private Exception lastException;

        private MockExceptionHandler() {
        }

        public void connectionFailed(SocketConnector connector, Exception ex) {
            this.lastException = ex;
            try {
                this.failureBarrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                e.printStackTrace();
            }
        }

        public Exception awaitConnectionFailed() throws InterruptedException {
            if (this.lastException != null) {
                return this.lastException;
            }
            try {
                this.failureBarrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                e.printStackTrace();
            }
            return this.lastException;
        }
    }
}

