/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.FormattingNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.testUtil.StatusChecker;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest {
    String BARE = Token.BARE_COMPOSITE_KEYWORD_TOKEN.getValue().toString();
    Context context = new ContextBase();

    @Test
    public void testBasic() throws Exception {
        Parser p = new Parser("hello");
        Node t = p.parse();
        Assert.assertEquals((long)0L, (long)t.getType());
        Assert.assertEquals((Object)"hello", (Object)t.getValue());
    }

    @Test
    public void testKeyword() throws Exception {
        Parser p = new Parser("hello%xyz");
        Node t = p.parse();
        Node witness = new Node(0, (Object)"hello");
        witness.next = new SimpleKeywordNode((Object)"xyz");
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%xyz{x}");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        SimpleKeywordNode n = new SimpleKeywordNode((Object)"xyz");
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("x");
        n.setOptions(optionList);
        witness.next = n;
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void testComposite() throws Exception {
        Parser p = new Parser("hello%(%child)");
        Node t = p.parse();
        Node witness = new Node(0, (Object)"hello");
        CompositeNode composite = new CompositeNode(this.BARE);
        SimpleKeywordNode child = new SimpleKeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        witness.next = composite;
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%(%child )");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode(this.BARE);
        child = new SimpleKeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        witness.next = composite;
        child.next = new Node(0, (Object)" ");
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%(%child %h)");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode(this.BARE);
        child = new SimpleKeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        child.next = new Node(0, (Object)" ");
        child.next.next = new SimpleKeywordNode((Object)"h");
        witness.next = composite;
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%(%child %h) %m");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode(this.BARE);
        child = new SimpleKeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        child.next = new Node(0, (Object)" ");
        child.next.next = new SimpleKeywordNode((Object)"h");
        witness.next = composite;
        composite.next = new Node(0, (Object)" ");
        composite.next.next = new SimpleKeywordNode((Object)"m");
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%( %child \\(%h\\) ) %m");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode(this.BARE);
        child = new Node(0, (Object)" ");
        composite.setChildNode((Node)child);
        SimpleKeywordNode c = child;
        c.next = new SimpleKeywordNode((Object)"child");
        c = c.next;
        c.next = new Node(0, (Object)" (");
        c = c.next;
        c.next = new SimpleKeywordNode((Object)"h");
        c = c.next;
        c.next = new Node(0, (Object)") ");
        c = c.next;
        witness.next = composite;
        composite.next = new Node(0, (Object)" ");
        composite.next.next = new SimpleKeywordNode((Object)"m");
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void testNested() throws Exception {
        Parser p = new Parser("%top %(%child%(%h))");
        Node t = p.parse();
        SimpleKeywordNode witness = new SimpleKeywordNode((Object)"top");
        Node w = witness.next = new Node(0, (Object)" ");
        CompositeNode composite = new CompositeNode(this.BARE);
        w = w.next = composite;
        SimpleKeywordNode child = new SimpleKeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        composite = new CompositeNode(this.BARE);
        child.next = composite;
        composite.setChildNode((Node)new SimpleKeywordNode((Object)"h"));
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void testFormattingInfo() throws Exception {
        Parser p = new Parser("%45x");
        Node t = p.parse();
        SimpleKeywordNode witness = new SimpleKeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("%4.5x");
        t = p.parse();
        witness = new SimpleKeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5));
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("%-4.5x");
        t = p.parse();
        witness = new SimpleKeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5, false, true));
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("%-4.-5x");
        t = p.parse();
        witness = new SimpleKeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5, false, false));
        Assert.assertEquals((Object)witness, (Object)t);
        p = new Parser("%-4.5x %12y");
        t = p.parse();
        witness = new SimpleKeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5, false, true));
        Node n = witness.next = new Node(0, (Object)" ");
        n = n.next = new SimpleKeywordNode((Object)"y");
        ((FormattingNode)n).setFormatInfo(new FormatInfo(12, Integer.MAX_VALUE));
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void testOptions0() throws Exception {
        Parser p = new Parser("%45x{'test '}");
        Node t = p.parse();
        SimpleKeywordNode witness = new SimpleKeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        ArrayList<String> ol = new ArrayList<String>();
        ol.add("test ");
        witness.setOptions(ol);
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void testOptions1() throws Exception {
        Parser p = new Parser("%45x{a, b}");
        Node t = p.parse();
        SimpleKeywordNode witness = new SimpleKeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        ArrayList<String> ol = new ArrayList<String>();
        ol.add("a");
        ol.add("b");
        witness.setOptions(ol);
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void keywordGluedToLitteral() throws Exception {
        Parser p = new Parser("%x{}a");
        Node t = p.parse();
        SimpleKeywordNode witness = new SimpleKeywordNode((Object)"x");
        witness.setOptions(new ArrayList());
        witness.next = new Node(0, (Object)"a");
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void testCompositeFormatting() throws Exception {
        Parser p = new Parser("hello%5(XYZ)");
        Node t = p.parse();
        Node witness = new Node(0, (Object)"hello");
        CompositeNode composite = new CompositeNode(this.BARE);
        composite.setFormatInfo(new FormatInfo(5, Integer.MAX_VALUE));
        Node child = new Node(0, (Object)"XYZ");
        composite.setChildNode(child);
        witness.next = composite;
        Assert.assertEquals((Object)witness, (Object)t);
    }

    @Test
    public void empty() {
        try {
            Parser p = new Parser("");
            p.parse();
            Assert.fail((String)"");
        }
        catch (ScanException scanException) {
            // empty catch block
        }
    }

    @Test
    public void lbcore193() throws Exception {
        try {
            Parser p = new Parser("hello%(abc");
            p.setContext(this.context);
            p.parse();
            Assert.fail((String)"where the is exception?");
        }
        catch (ScanException ise) {
            Assert.assertEquals((Object)"Expecting RIGHT_PARENTHESIS token but got null", (Object)ise.getMessage());
        }
        StatusChecker sc = new StatusChecker(this.context);
        sc.assertContainsMatch("Expecting RIGHT_PARENTHESIS");
        sc.assertContainsMatch("See also http://logback.qos.ch/codes.html#missingRightParenthesis");
    }
}

