/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.pattern.parser.SamplePatternLayout;
import ch.qos.logback.core.pattern.parser.test.AbstractPatternLayoutBaseTest;
import ch.qos.logback.core.testUtil.StatusChecker;
import org.junit.Assert;
import org.junit.Test;

public class SamplePatternLayoutTest
extends AbstractPatternLayoutBaseTest<Object> {
    Context context = new ContextBase();
    StatusChecker checker = new StatusChecker(this.context);

    @Override
    public PatternLayoutBase<Object> getPatternLayoutBase() {
        return new SamplePatternLayout<Object>();
    }

    @Override
    public Object getEventObject() {
        return new Object();
    }

    @Test
    public void testOK() {
        PatternLayoutBase<Object> plb = this.getPatternLayoutBase();
        ContextBase context = new ContextBase();
        plb.setContext((Context)context);
        plb.setPattern("x%OTT");
        plb.start();
        String s = plb.doLayout(new Object());
        Assert.assertEquals((Object)"x123", (Object)s);
    }

    @Test
    public void testEscapeClosingParentheses() {
        PatternLayoutBase<Object> plb = this.getPatternLayoutBase();
        ContextBase context = new ContextBase();
        plb.setContext((Context)context);
        plb.setPattern("x(%OTT\\)y");
        plb.start();
        String s = plb.doLayout(new Object());
        Assert.assertEquals((Object)"x(123)y", (Object)s);
    }

    @Test
    public void testEscapeBothParentheses() {
        PatternLayoutBase<Object> plb = this.getPatternLayoutBase();
        ContextBase context = new ContextBase();
        plb.setContext((Context)context);
        plb.setPattern("x\\(%OTT\\)y");
        plb.start();
        String s = plb.doLayout(new Object());
        Assert.assertEquals((Object)"x(123)y", (Object)s);
    }

    @Test
    public void testPercentAsLiteral() {
        PatternLayoutBase<Object> plb = this.getPatternLayoutBase();
        ContextBase context = new ContextBase();
        plb.setContext((Context)context);
        plb.setPattern("hello \\% world");
        plb.start();
        String s = plb.doLayout(new Object());
        Assert.assertEquals((Object)"hello % world", (Object)s);
    }

    @Test
    public void noClosingCurlyBrace() {
        PatternLayoutBase<Object> plb = this.getPatternLayoutBase();
        plb.setContext(this.context);
        plb.setPattern("%x %hello{asd");
        plb.start();
        this.checker.assertContainsMatch(2, "Failed to parse pattern");
    }

    @Override
    public Context getContext() {
        return this.context;
    }
}

