/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.sift.AppenderFactory;
import ch.qos.logback.core.sift.AppenderTracker;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AppenderTrackerTest {
    Context context = new ContextBase();
    ListAppenderFactory listAppenderFactory = new ListAppenderFactory();
    int diff = RandomUtil.getPositiveInt();
    AppenderTracker<Object> appenderTracker = new AppenderTracker(this.context, (AppenderFactory)this.listAppenderFactory);
    String key = "k-" + this.diff;
    long now = 3000L;

    @Before
    public void setUp() {
    }

    @Test
    public void removeStaleComponentsShouldNotBomb() {
        this.appenderTracker.removeStaleComponents(this.now);
        Assert.assertEquals((long)0L, (long)this.appenderTracker.getComponentCount());
    }

    @Test
    public void findingTheInexistentShouldNotBomb() {
        Assert.assertNull((Object)this.appenderTracker.find(this.key));
        this.now += 1800001L;
        this.appenderTracker.removeStaleComponents(this.now);
        Assert.assertNull((Object)this.appenderTracker.find(this.key));
    }

    @Test
    public void smoke() {
        Appender a = (Appender)this.appenderTracker.getOrCreate(this.key, this.now);
        Assert.assertTrue((boolean)a.isStarted());
        this.now += 1800001L;
        this.appenderTracker.removeStaleComponents(this.now);
        Assert.assertFalse((boolean)a.isStarted());
        Assert.assertNull((Object)this.appenderTracker.find(this.key));
    }

    @Test
    public void endOfLivedAppendersShouldBeRemovedAfterLingeringTimeout() {
        Appender a = (Appender)this.appenderTracker.getOrCreate(this.key, this.now);
        this.appenderTracker.endOfLife(this.key);
        this.now += 10001L;
        this.appenderTracker.removeStaleComponents(this.now);
        Assert.assertFalse((boolean)a.isStarted());
        a = (Appender)this.appenderTracker.find(this.key);
        Assert.assertNull((Object)a);
    }

    @Test
    public void endOfLivedAppenderShouldBeAvailableDuringLingeringPeriod() {
        Appender a = (Appender)this.appenderTracker.getOrCreate(this.key, this.now);
        this.appenderTracker.endOfLife(this.key);
        this.appenderTracker.removeStaleComponents(this.now);
        Appender lingering = (Appender)this.appenderTracker.getOrCreate(this.key, this.now);
        Assert.assertTrue((boolean)lingering.isStarted());
        Assert.assertTrue((a == lingering ? 1 : 0) != 0);
        this.now += 10001L;
        this.appenderTracker.removeStaleComponents(this.now);
        Assert.assertFalse((boolean)a.isStarted());
        a = (Appender)this.appenderTracker.find(this.key);
        Assert.assertNull((Object)a);
    }

    @Test
    public void trackerShouldHonorMaxComponentsParameter() {
        ArrayList<Appender> appenderList = new ArrayList<Appender>();
        int max = 10;
        this.appenderTracker.setMaxComponents(max);
        for (int i = 0; i < max + 1; ++i) {
            Appender a = (Appender)this.appenderTracker.getOrCreate(this.key + "-" + i, this.now++);
            appenderList.add(a);
        }
        this.appenderTracker.removeStaleComponents(this.now++);
        Assert.assertEquals((long)max, (long)this.appenderTracker.allKeys().size());
        Assert.assertNull((Object)this.appenderTracker.find(this.key + "-" + 0));
        Assert.assertFalse((boolean)((Appender)appenderList.get(0)).isStarted());
    }

    @Test
    public void trackerShouldHonorTimeoutParameter() {
        ArrayList<Appender> appenderList = new ArrayList<Appender>();
        int timeout = 2;
        this.appenderTracker.setTimeout((long)timeout);
        for (int i = 0; i <= timeout; ++i) {
            Appender a = (Appender)this.appenderTracker.getOrCreate(this.key + "-" + i, this.now++);
            appenderList.add(a);
        }
        long numComponentsCreated = timeout + 1;
        Assert.assertEquals((long)numComponentsCreated, (long)this.appenderTracker.allKeys().size());
        this.appenderTracker.removeStaleComponents(this.now++);
        Assert.assertEquals((long)(numComponentsCreated - 1L), (long)this.appenderTracker.allKeys().size());
        Assert.assertNull((Object)this.appenderTracker.find(this.key + "-" + 0));
        Assert.assertFalse((boolean)((Appender)appenderList.get(0)).isStarted());
        for (int i = 1; i <= timeout; ++i) {
            Assert.assertNotNull((Object)this.appenderTracker.find(this.key + "-" + i));
            Assert.assertTrue((boolean)((Appender)appenderList.get(i)).isStarted());
        }
    }

    static class ListAppenderFactory
    implements AppenderFactory<Object> {
        ListAppenderFactory() {
        }

        public Appender<Object> buildAppender(Context context, String discriminatingValue) throws JoranException {
            ListAppender la = new ListAppender();
            la.setContext(context);
            la.setName(discriminatingValue);
            la.start();
            return la;
        }
    }
}

