/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.ComponentTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CyclicBufferTrackerT<E>
implements ComponentTracker<CyclicBuffer<E>> {
    int bufferSize = 256;
    int maxComponents = 64;
    List<TEntry<E>> liveList = new LinkedList<TEntry<E>>();
    List<TEntry<E>> lingererList = new LinkedList<TEntry<E>>();
    long lastCheck = 0L;

    private TEntry<E> getEntry(List<TEntry<E>> list, String k) {
        for (int i = 0; i < list.size(); ++i) {
            TEntry<E> te = list.get(i);
            if (!te.key.equals(k)) continue;
            return te;
        }
        return null;
    }

    private TEntry<E> getFromEitherList(String key) {
        TEntry<E> entry = this.getEntry(this.liveList, key);
        if (entry != null) {
            return entry;
        }
        return this.getEntry(this.lingererList, key);
    }

    private List<String> keysAsOrderedList(List<TEntry<E>> list) {
        Collections.sort(list);
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < list.size(); ++i) {
            TEntry<E> te = list.get(i);
            result.add(te.key);
        }
        return result;
    }

    List<String> liveKeysAsOrderedList() {
        return this.keysAsOrderedList(this.liveList);
    }

    List<String> lingererKeysAsOrderedList() {
        return this.keysAsOrderedList(this.lingererList);
    }

    public Set<String> allKeys() {
        HashSet<String> allKeys = new HashSet<String>();
        for (TEntry<E> e : this.liveList) {
            allKeys.add(e.key);
        }
        for (TEntry<E> e : this.lingererList) {
            allKeys.add(e.key);
        }
        return allKeys;
    }

    public Collection<CyclicBuffer<E>> allComponents() {
        ArrayList allComponents = new ArrayList();
        for (TEntry<E> e : this.liveList) {
            allComponents.add(e.value);
        }
        for (TEntry<E> e : this.lingererList) {
            allComponents.add(e.value);
        }
        return allComponents;
    }

    public CyclicBuffer<E> find(String key) {
        TEntry<E> te = this.getFromEitherList(key);
        if (te == null) {
            return null;
        }
        return te.value;
    }

    public CyclicBuffer<E> getOrCreate(String key, long timestamp) {
        TEntry<Object> te = this.getFromEitherList(key);
        if (te == null) {
            CyclicBuffer cb = new CyclicBuffer(this.bufferSize);
            te = new TEntry(key, cb, timestamp);
            this.liveList.add(te);
            if (this.liveList.size() > this.maxComponents) {
                Collections.sort(this.liveList);
                this.liveList.remove(0);
            }
        } else {
            te.timestamp = timestamp;
            Collections.sort(this.liveList);
        }
        return te.value;
    }

    public void endOfLife(String k) {
        TEntry<E> te = null;
        boolean found = false;
        for (int i = 0; i < this.liveList.size(); ++i) {
            te = this.liveList.get(i);
            if (!te.key.equals(k)) continue;
            this.liveList.remove(i);
            found = true;
            break;
        }
        if (found) {
            this.lingererList.add(te);
        }
    }

    private boolean isEntryStale(TEntry<E> entry, long now) {
        return entry.timestamp + 1800000L < now;
    }

    private boolean isEntryDoneLingering(TEntry<E> tEntry, long now) {
        return tEntry.timestamp + 10000L < now;
    }

    public void removeStaleComponents(long now) {
        if (this.isTooSoonForRemovalIteration(now)) {
            return;
        }
        Collections.sort(this.liveList);
        Collections.sort(this.lingererList);
        this.removeComponentsInExcessFromMainList();
        this.removeStaleComponentsFromMainList(now);
        this.removeStaleComponentsFromLingerersList(now);
    }

    private void removeComponentsInExcessFromMainList() {
        while (this.liveList.size() > this.maxComponents) {
            this.liveList.remove(0);
        }
    }

    private void removeStaleComponentsFromMainList(long now) {
        while (this.liveList.size() != 0 && this.isEntryStale(this.liveList.get(0), now)) {
            this.liveList.remove(0);
        }
    }

    private void removeStaleComponentsFromLingerersList(long now) {
        while (this.lingererList.size() != 0 && this.isEntryDoneLingering(this.lingererList.get(0), now)) {
            this.lingererList.remove(0);
        }
    }

    private boolean isTooSoonForRemovalIteration(long now) {
        if (this.lastCheck + 1000L > now) {
            return true;
        }
        this.lastCheck = now;
        return false;
    }

    public int getComponentCount() {
        return this.liveList.size() + this.lingererList.size();
    }

    private class TEntry<X>
    implements Comparable<TEntry<?>> {
        String key;
        CyclicBuffer<E> value;
        long timestamp;

        TEntry(String k, CyclicBuffer<E> v, long timestamp) {
            this.key = k;
            this.value = v;
            this.timestamp = timestamp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        @Override
        public int compareTo(TEntry<?> o) {
            if (!(o instanceof TEntry)) {
                throw new IllegalArgumentException("arguments must be of type " + TEntry.class);
            }
            TEntry<?> other = o;
            if (this.timestamp > other.timestamp) {
                return 1;
            }
            if (this.timestamp == other.timestamp) {
                return 0;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TEntry other = (TEntry)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }
    }
}

