/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.LocationUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class LocationUtilTest {
    private static final String TEST_CLASSPATH_RESOURCE = "util/testResource.txt";
    private static final String TEST_PATTERN = "TEST RESOURCE";

    @Test
    public void testImplicitClasspathUrl() throws Exception {
        URL url = LocationUtil.urlForResource((String)TEST_CLASSPATH_RESOURCE);
        this.validateResource(url);
    }

    @Test
    public void testExplicitClasspathUrl() throws Exception {
        URL url = LocationUtil.urlForResource((String)"classpath:util/testResource.txt");
        this.validateResource(url);
    }

    @Test
    public void testExplicitClasspathUrlWithLeadingSlash() throws Exception {
        URL url = LocationUtil.urlForResource((String)"classpath:/util/testResource.txt");
        this.validateResource(url);
    }

    @Test(expected=MalformedURLException.class)
    public void testExplicitClasspathUrlEmptyPath() throws Exception {
        LocationUtil.urlForResource((String)"classpath:");
    }

    @Test(expected=MalformedURLException.class)
    public void testExplicitClasspathUrlWithRootPath() throws Exception {
        LocationUtil.urlForResource((String)"classpath:/");
    }

    @Test
    public void testFileUrl() throws Exception {
        File file = File.createTempFile("testResource", ".txt");
        file.deleteOnExit();
        PrintWriter writer = new PrintWriter(file);
        writer.println(TEST_PATTERN);
        writer.close();
        URL url = file.toURI().toURL();
        this.validateResource(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateResource(URL url) throws IOException {
        InputStream inputStream = url.openStream();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            Assert.assertEquals((Object)TEST_PATTERN, (Object)line);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }
}

