/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.LifeCycleManager;
import ch.qos.logback.core.MockLifeCycleComponent;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.junit.Assert;
import org.junit.Test;

public class ContextBaseTest {
    private InstrumentedLifeCycleManager lifeCycleManager = new InstrumentedLifeCycleManager();
    private InstrumentedContextBase context = new InstrumentedContextBase(this.lifeCycleManager);

    @Test
    public void renameDefault() {
        this.context.setName("default");
        this.context.setName("hello");
    }

    @Test
    public void idempotentNameTest() {
        this.context.setName("hello");
        this.context.setName("hello");
    }

    @Test
    public void renameTest() {
        this.context.setName("hello");
        try {
            this.context.setName("x");
            Assert.fail((String)"renaming is not allowed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void resetTest() {
        this.context.setName("hello");
        this.context.putProperty("keyA", "valA");
        this.context.putObject("keyA", "valA");
        Assert.assertEquals((Object)"valA", (Object)this.context.getProperty("keyA"));
        Assert.assertEquals((Object)"valA", (Object)this.context.getObject("keyA"));
        MockLifeCycleComponent component = new MockLifeCycleComponent();
        this.context.register(component);
        Assert.assertSame((Object)component, (Object)this.lifeCycleManager.getLastComponent());
        this.context.reset();
        Assert.assertNull((Object)this.context.getProperty("keyA"));
        Assert.assertNull((Object)this.context.getObject("keyA"));
        Assert.assertTrue((boolean)this.lifeCycleManager.isReset());
    }

    @Test
    public void contextNameProperty() {
        Assert.assertNull((Object)this.context.getProperty("CONTEXT_NAME"));
        String HELLO = "hello";
        this.context.setName(HELLO);
        Assert.assertEquals((Object)HELLO, (Object)this.context.getProperty("CONTEXT_NAME"));
        Assert.assertEquals((Object)HELLO, (Object)this.context.getProperty("CONTEXT_NAME"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextThreadpoolIsDaemonized() throws InterruptedException {
        ExecutorService execSvc = this.context.getExecutorService();
        final ArrayList executingThreads = new ArrayList();
        execSvc.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList arrayList = executingThreads;
                synchronized (arrayList) {
                    executingThreads.add(Thread.currentThread());
                    executingThreads.notifyAll();
                }
            }
        });
        ArrayList arrayList = executingThreads;
        synchronized (arrayList) {
            while (executingThreads.isEmpty()) {
                executingThreads.wait();
            }
        }
        Assert.assertTrue((String)"executing thread should be a daemon thread.", (boolean)((Thread)executingThreads.get(0)).isDaemon());
    }

    private static class InstrumentedLifeCycleManager
    extends LifeCycleManager {
        private LifeCycle lastComponent;
        private boolean reset;

        private InstrumentedLifeCycleManager() {
        }

        public void register(LifeCycle component) {
            this.lastComponent = component;
            super.register(component);
        }

        public void reset() {
            this.reset = true;
            super.reset();
        }

        public LifeCycle getLastComponent() {
            return this.lastComponent;
        }

        public boolean isReset() {
            return this.reset;
        }
    }

    private static class InstrumentedContextBase
    extends ContextBase {
        private final LifeCycleManager lifeCycleManager;

        public InstrumentedContextBase(LifeCycleManager lifeCycleManager) {
            this.lifeCycleManager = lifeCycleManager;
        }

        protected LifeCycleManager getLifeCycleManager() {
            return this.lifeCycleManager;
        }
    }
}

