/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.net.AbstractSocketAppender;
import ch.qos.logback.core.net.AutoFlushingObjectWriter;
import ch.qos.logback.core.net.ObjectWriterFactory;
import ch.qos.logback.core.net.QueueFactory;
import ch.qos.logback.core.net.mock.MockContext;
import ch.qos.logback.core.net.server.test.ServerSocketUtil;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import ch.qos.logback.core.util.ExecutorServiceUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractSocketAppenderIntegrationTest {
    private static final int TIMEOUT = 2000;
    private ScheduledExecutorService executorService = ExecutorServiceUtil.newScheduledExecutorService();
    private MockContext mockContext = new MockContext(this.executorService);
    private AutoFlushingObjectWriter objectWriter;
    private ObjectWriterFactory objectWriterFactory = new SpyProducingObjectWriterFactory();
    private LinkedBlockingDeque<String> deque = (LinkedBlockingDeque)Mockito.spy(new LinkedBlockingDeque(1));
    private QueueFactory queueFactory = (QueueFactory)Mockito.mock(QueueFactory.class);
    private InstrumentedSocketAppender instrumentedAppender = new InstrumentedSocketAppender(this.queueFactory, this.objectWriterFactory);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.queueFactory.newLinkedBlockingDeque(Matchers.anyInt())).thenReturn(this.deque);
        this.instrumentedAppender.setContext((Context)this.mockContext);
    }

    @After
    public void tearDown() throws Exception {
        this.instrumentedAppender.stop();
        Assert.assertFalse((boolean)this.instrumentedAppender.isStarted());
        this.executorService.shutdownNow();
        Assert.assertTrue((boolean)this.executorService.awaitTermination(2000L, TimeUnit.MILLISECONDS));
    }

    @Ignore
    @Test
    public void dispatchesEvents() throws Exception {
        ServerSocket serverSocket = ServerSocketUtil.createServerSocket();
        this.instrumentedAppender.setRemoteHost(serverSocket.getInetAddress().getHostAddress());
        this.instrumentedAppender.setPort(serverSocket.getLocalPort());
        this.instrumentedAppender.start();
        Socket appenderSocket = serverSocket.accept();
        serverSocket.close();
        this.instrumentedAppender.append("some event");
        ((LinkedBlockingDeque)Mockito.verify(this.deque, (VerificationMode)Mockito.timeout((long)2000L).atLeastOnce())).takeFirst();
        ((AutoFlushingObjectWriter)Mockito.verify((Object)this.objectWriter, (VerificationMode)Mockito.timeout((long)2000L))).write((Object)"some event");
        ObjectInputStream ois = new ObjectInputStream(appenderSocket.getInputStream());
        Assert.assertEquals((Object)"some event", (Object)ois.readObject());
        appenderSocket.close();
    }

    private class SpyProducingObjectWriterFactory
    extends ObjectWriterFactory {
        private SpyProducingObjectWriterFactory() {
        }

        public AutoFlushingObjectWriter newAutoFlushingObjectWriter(OutputStream outputStream) throws IOException {
            AbstractSocketAppenderIntegrationTest.this.objectWriter = (AutoFlushingObjectWriter)Mockito.spy((Object)super.newAutoFlushingObjectWriter(outputStream));
            return AbstractSocketAppenderIntegrationTest.this.objectWriter;
        }
    }

    private static class InstrumentedSocketAppender
    extends AbstractSocketAppender<String> {
        public InstrumentedSocketAppender(QueueFactory queueFactory, ObjectWriterFactory objectWriterFactory) {
            super(queueFactory, objectWriterFactory);
        }

        protected void postProcessEvent(String event) {
        }

        protected PreSerializationTransformer<String> getPST() {
            return new PreSerializationTransformer<String>(){

                public Serializable transform(String event) {
                    return event;
                }
            };
        }
    }
}

