/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.net.HardenedObjectInputStream;
import ch.qos.logback.core.net.Innocent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HardenedObjectInputStreamTest {
    ByteArrayOutputStream bos;
    ObjectOutputStream oos;
    HardenedObjectInputStream inputStream;
    String[] whitelist = new String[]{Innocent.class.getName()};

    @Before
    public void setUp() throws Exception {
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void smoke() throws ClassNotFoundException, IOException {
        Innocent innocent = new Innocent();
        innocent.setAnInt(1);
        innocent.setAnInteger(2);
        innocent.setaString("smoke");
        Innocent back = this.writeAndRead(innocent);
        Assert.assertEquals((Object)innocent, (Object)back);
    }

    private Innocent writeAndRead(Innocent innocent) throws IOException, ClassNotFoundException {
        this.writeObject(this.oos, innocent);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.inputStream = new HardenedObjectInputStream((InputStream)bis, this.whitelist);
        Innocent fooBack = (Innocent)this.inputStream.readObject();
        this.inputStream.close();
        return fooBack;
    }

    private void writeObject(ObjectOutputStream oos, Object o) throws IOException {
        oos.writeObject(o);
        oos.flush();
        oos.close();
    }
}

