/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import org.junit.Assert;
import org.junit.Test;

public class CyclicBufferTrackerTest {
    CyclicBufferTracker<Object> tracker = new CyclicBufferTracker();
    String key = "a";

    @Test
    public void empty0() {
        long now = 3000L;
        this.tracker.removeStaleComponents(now);
        Assert.assertEquals((long)0L, (long)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((long)0L, (long)this.tracker.getComponentCount());
    }

    @Test
    public void empty1() {
        long now = 3000L;
        Assert.assertNotNull((Object)this.tracker.getOrCreate(this.key, now++));
        this.tracker.removeStaleComponents(now += 1801000L);
        Assert.assertEquals((long)0L, (long)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((long)0L, (long)this.tracker.getComponentCount());
        Assert.assertNotNull((Object)this.tracker.getOrCreate(this.key, now++));
    }

    @Test
    public void smoke() {
        long now = 3000L;
        CyclicBuffer cb = (CyclicBuffer)this.tracker.getOrCreate(this.key, now);
        Assert.assertEquals((Object)cb, (Object)this.tracker.getOrCreate(this.key, now++));
        this.tracker.removeStaleComponents(now += 1801000L);
        Assert.assertEquals((long)0L, (long)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((long)0L, (long)this.tracker.getComponentCount());
    }

    @Test
    public void destroy() {
        long now = 3000L;
        CyclicBuffer cb = (CyclicBuffer)this.tracker.getOrCreate(this.key, now);
        cb.add(new Object());
        Assert.assertEquals((long)1L, (long)cb.length());
        this.tracker.endOfLife(this.key);
        this.tracker.removeStaleComponents(now += 10010L);
        Assert.assertEquals((long)0L, (long)this.tracker.liveKeysAsOrderedList().size());
        Assert.assertEquals((long)0L, (long)this.tracker.getComponentCount());
        Assert.assertEquals((long)0L, (long)cb.length());
    }
}

