/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusUtil;
import org.junit.Assert;
import org.junit.Test;

public class StatusUtilTest {
    Context context = new ContextBase();
    StatusUtil statusUtil = new StatusUtil(this.context);

    @Test
    public void emptyStatusListShouldResultInNotFound() {
        Assert.assertEquals((long)-1L, (long)this.statusUtil.timeOfLastReset());
    }

    @Test
    public void withoutResetsStatusUtilShouldReturnNotFound() {
        this.context.getStatusManager().add((Status)new InfoStatus("test", (Object)this));
        Assert.assertEquals((long)-1L, (long)this.statusUtil.timeOfLastReset());
    }

    @Test
    public void statusListShouldReturnLastResetTime() {
        this.context.getStatusManager().add((Status)new InfoStatus("test", (Object)this));
        long resetTime = System.currentTimeMillis();
        this.context.getStatusManager().add((Status)new InfoStatus("Will reset and reconfigure context ", (Object)this));
        this.context.getStatusManager().add((Status)new InfoStatus("bla", (Object)this));
        Assert.assertTrue((resetTime <= this.statusUtil.timeOfLastReset() ? 1 : 0) != 0);
    }
}

