/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.encoder.JsonEscapeUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonEscapeUtilTest {
    JsonEscapeUtilTest() {
    }

    @Test
    public void smokeTestEscapeCodes() {
        Assertions.assertEquals((Object)"\\u0001", (Object)JsonEscapeUtil.ESCAPE_CODES[1]);
        Assertions.assertEquals((Object)"\\u0005", (Object)JsonEscapeUtil.ESCAPE_CODES[5]);
        Assertions.assertEquals((Object)"\\b", (Object)JsonEscapeUtil.ESCAPE_CODES[8]);
        Assertions.assertEquals((Object)"\\t", (Object)JsonEscapeUtil.ESCAPE_CODES[9]);
        Assertions.assertEquals((Object)"\\n", (Object)JsonEscapeUtil.ESCAPE_CODES[10]);
        Assertions.assertEquals((Object)"\\u000B", (Object)JsonEscapeUtil.ESCAPE_CODES[11]);
        Assertions.assertEquals((Object)"\\f", (Object)JsonEscapeUtil.ESCAPE_CODES[12]);
        Assertions.assertEquals((Object)"\\r", (Object)JsonEscapeUtil.ESCAPE_CODES[13]);
        Assertions.assertEquals((Object)"\\u000E", (Object)JsonEscapeUtil.ESCAPE_CODES[14]);
        Assertions.assertEquals((Object)"\\u001A", (Object)JsonEscapeUtil.ESCAPE_CODES[26]);
    }

    @Test
    public void smokeTestEscapeString() {
        Assertions.assertEquals((Object)"abc", (Object)JsonEscapeUtil.jsonEscapeString((String)"abc"));
        Assertions.assertEquals((Object)"{world: \\\"world\\\"}", (Object)JsonEscapeUtil.jsonEscapeString((String)"{world: \"world\"}"));
        Assertions.assertEquals((Object)"{world: \\\"world\\\"}", (Object)JsonEscapeUtil.jsonEscapeString((String)"{world: \"world\"}"));
    }

    @Test
    public void testEscapingLF() {
        String input = "{\nhello: \"wo\nrld\"}";
        System.out.println(input);
        Assertions.assertEquals((Object)"{\\nhello: \\\"wo\\nrld\\\"}", (Object)JsonEscapeUtil.jsonEscapeString((String)input));
    }

    @Test
    public void testEscapingTab() {
        String input = "{hello: \"\tworld\"}";
        System.out.println(input);
        Assertions.assertEquals((Object)"{hello: \\\"\\tworld\\\"}", (Object)JsonEscapeUtil.jsonEscapeString((String)input));
    }
}

