/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.net.ssl.KeyStoreFactoryBean;
import java.security.KeyStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyStoreFactoryBeanTest {
    private KeyStoreFactoryBean factoryBean = new KeyStoreFactoryBean();

    @Test
    public void testDefaults() throws Exception {
        this.factoryBean.setLocation("net/ssl/keystore.jks");
        Assertions.assertNotNull((Object)this.factoryBean.createKeyStore());
    }

    @Test
    public void testExplicitProvider() throws Exception {
        this.factoryBean.setLocation("net/ssl/keystore.jks");
        KeyStore keyStore = this.factoryBean.createKeyStore();
        this.factoryBean.setProvider(keyStore.getProvider().getName());
        Assertions.assertNotNull((Object)this.factoryBean.createKeyStore());
    }

    @Test
    public void testExplicitType() throws Exception {
        this.factoryBean.setLocation("net/ssl/keystore.jks");
        this.factoryBean.setType("JKS");
        Assertions.assertNotNull((Object)this.factoryBean.createKeyStore());
    }

    @Test
    public void testPKCS12Type() throws Exception {
        this.factoryBean.setLocation("net/ssl/keystore.p12");
        this.factoryBean.setType("PKCS12");
        Assertions.assertNotNull((Object)this.factoryBean.createKeyStore());
    }

    @Test
    public void testExplicitPassphrase() throws Exception {
        this.factoryBean.setLocation("net/ssl/keystore.jks");
        this.factoryBean.setPassword("changeit");
        Assertions.assertNotNull((Object)this.factoryBean.createKeyStore());
    }
}

