/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class RenameUtilTest {
    Encoder<Object> encoder;
    Context context = new ContextBase();
    StatusChecker statusChecker = new StatusChecker(this.context);
    long currentTime = System.currentTimeMillis();
    int diff = RandomUtil.getPositiveInt();
    protected String randomOutputDirAsStr = "target/test-output/" + this.diff + "/";
    protected File randomOutputDir = new File(this.randomOutputDirAsStr);

    @BeforeEach
    public void setUp() throws Exception {
        this.encoder = new EchoEncoder();
        this.randomOutputDir.mkdirs();
    }

    @Test
    public void renameToNonExistingDirectory() throws IOException, RolloverFailure {
        RenameUtil renameUtil = new RenameUtil();
        renameUtil.setContext(this.context);
        int diff2 = RandomUtil.getPositiveInt();
        File fromFile = File.createTempFile("from" + this.diff, "test", this.randomOutputDir);
        String randomTARGETDir = "target/test-output/" + diff2;
        renameUtil.rename(fromFile.toString(), new File(randomTARGETDir + "/to.test").toString());
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.context);
        Assertions.assertTrue((boolean)this.statusChecker.isErrorFree(0L));
    }

    @Test
    public void renameLockedAbstractFile_LOGBACK_1054() throws IOException, RolloverFailure {
        RenameUtil renameUtil = new RenameUtil();
        renameUtil.setContext(this.context);
        String abstractFileName = "abstract_pathname-" + this.diff;
        String src = "target/test-output/" + abstractFileName;
        String target = abstractFileName + ".target";
        this.makeFile(src);
        FileInputStream fisLock = new FileInputStream(src);
        renameUtil.rename(src, target);
        fisLock.close();
        StatusPrinter.print((Context)this.context);
        Assertions.assertEquals((int)0, (int)this.statusChecker.matchCount("Parent of target file ." + target + ". is null"));
    }

    @Test
    @Disabled
    public void MANUAL_renamingOnDifferentVolumesOnLinux() throws IOException, RolloverFailure {
        RenameUtil renameUtil = new RenameUtil();
        renameUtil.setContext(this.context);
        String src = "/tmp/ramdisk/foo.txt";
        this.makeFile(src);
        renameUtil.rename(src, "/tmp/foo" + this.diff + ".txt");
        StatusPrinter.print((Context)this.context);
    }

    @Test
    @Disabled
    public void MANUAL_renamingOnDifferentVolumesOnWindows() throws IOException, RolloverFailure {
        RenameUtil renameUtil = new RenameUtil();
        renameUtil.setContext(this.context);
        String src = "c:/tmp/foo.txt";
        this.makeFile(src);
        renameUtil.rename(src, "d:/tmp/foo" + this.diff + ".txt");
        StatusPrinter.print((Context)this.context);
        Assertions.assertTrue((boolean)this.statusChecker.isErrorFree(0L));
    }

    private void makeFile(String src) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(src);
        fos.write(("hello" + this.diff).getBytes());
        fos.close();
    }
}

