/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.FileStoreUtil;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class FileStoreUtilTest {
    int diff = RandomUtil.getPositiveInt();
    String pathPrefix = "target/test-output/fs" + this.diff + "/";

    @Test
    public void filesOnSameFolderShouldBeOnTheSameFileStore() throws RolloverFailure, IOException {
        if (!EnvUtil.isJDK7OrHigher()) {
            return;
        }
        File parent = new File(this.pathPrefix);
        File file = new File(this.pathPrefix + "filesOnSameFolderShouldBeOnTheSameFileStore");
        FileUtil.createMissingParentDirectories((File)file);
        file.createNewFile();
        Assertions.assertTrue((boolean)FileStoreUtil.areOnSameFileStore((File)parent, (File)file));
    }

    @Disabled
    @Test
    public void manual_filesOnDifferentVolumesShouldBeDetectedAsSuch() throws RolloverFailure {
        if (!EnvUtil.isJDK7OrHigher()) {
            return;
        }
        File c = new File("c:/tmp/");
        File d = new File("d:/");
        Assertions.assertFalse((boolean)FileStoreUtil.areOnSameFileStore((File)c, (File)d));
    }
}

