/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CyclicBufferTrackerTest {
    CyclicBufferTracker<Object> tracker = new CyclicBufferTracker();
    String key = "a";

    @Test
    public void empty0() {
        long now = 3000L;
        this.tracker.removeStaleComponents(now);
        Assertions.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assertions.assertEquals((int)0, (int)this.tracker.getComponentCount());
    }

    @Test
    public void empty1() {
        long now = 3000L;
        Assertions.assertNotNull((Object)this.tracker.getOrCreate(this.key, now++));
        this.tracker.removeStaleComponents(now += 1801000L);
        Assertions.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assertions.assertEquals((int)0, (int)this.tracker.getComponentCount());
        Assertions.assertNotNull((Object)this.tracker.getOrCreate(this.key, now++));
    }

    @Test
    public void smoke() {
        long now = 3000L;
        CyclicBuffer cb = (CyclicBuffer)this.tracker.getOrCreate(this.key, now);
        Assertions.assertEquals((Object)cb, (Object)this.tracker.getOrCreate(this.key, now++));
        this.tracker.removeStaleComponents(now += 1801000L);
        Assertions.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assertions.assertEquals((int)0, (int)this.tracker.getComponentCount());
    }

    @Test
    public void destroy() {
        long now = 3000L;
        CyclicBuffer cb = (CyclicBuffer)this.tracker.getOrCreate(this.key, now);
        cb.add(new Object());
        Assertions.assertEquals((int)1, (int)cb.length());
        this.tracker.endOfLife(this.key);
        this.tracker.removeStaleComponents(now += 10010L);
        Assertions.assertEquals((int)0, (int)this.tracker.liveKeysAsOrderedList().size());
        Assertions.assertEquals((int)0, (int)this.tracker.getComponentCount());
        Assertions.assertEquals((int)0, (int)cb.length());
    }
}

